<?php
$roles = [
    'chronicle' =>
    [
        'superadmin' => ['administrator' => 'Administrator', 'admin' => 'Admin', 'webuser' => 'Web User'],
    ],
    [
        'administrator' => ['admin' => 'Admin'],
    ]
];
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-backend',
    'basePath' => dirname(__DIR__),
    'controllerNamespace' => 'backend\controllers',
    'bootstrap' => ['log'],
	'timeZone' => 'Asia/Kolkata',
    'modules' => [
       'dynagrid' => [
            'class' => '\kartik\dynagrid\Module',
        ],
        'gridview' => [
            'class' => '\kartik\grid\Module'
        ],
	   'user' => [
        // following line will restrict access to profile, recovery, registration and settings controllers from backend
        'as backend' => 'dektrium\user\filters\BackendFilter',
       ],
	   'redactor' => [
            'class' => 'yii\redactor\RedactorModule',
			'uploadDir' => \Yii::getAlias('@backend') . '/web/uploads/images',
            'uploadUrl' => '@web/uploads/images',
            'imageAllowExtensions' => ['jpg', 'png', 'gif']
        ],
    ],
    'components' => [
	  'assetManager' => [
          //'forceCopy' => YII_ENV_DEV ? true : false,
		  'appendTimestamp' => true,
        ],
        'request' => [
            'csrfParam' => '_csrf-backend',
        ],
        'pdf'=>[
			'class'=>'backend\components\ExportToPdf',
		],
		'excel'=>[
			'class'=>'backend\components\ExportToExcel',
		],
        'user' => [
			'identityCookie' => [
				'name'     => '_backendIdentity',
				'path'     => '/',
				'httpOnly' => true,
			],	
		],
		'session' => [
			'name' => 'BACKENDSESSID',
			'cookieParams' => [
				'httpOnly' => true,
				'path'     => '/',
			],
		],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
	    'urlManager' => [
             'class' => 'yii\web\UrlManager',
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'enableStrictParsing' => false,
            'rules' => [
                '/user/login' => '/user/security/login',
				'/user/recovery/request' => '/user/recovery/request',
				'/user/registration/resend' => '/user/registration/resend',
				'/user/register' => '/user/registration/register',
				'/user/recovery/reset' => '/user/recovery/reset',
				'/user/registration/confirm' => '/user/registration/confirm',
				'/user/logout' => '/user/security/logout',
				'<controller:\w+>/<action:\w+>/' => '<controller>/<action>',
            ],
        ],
	
    ],
    'params' => $params,
	'params' => ['role' => $roles],
];
