<?php
namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\CricketCategory;
use backend\models\CricketCategorySearch;
use backend\models\Cricket;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use pheme\grid\actions\ToggleAction;

class CricketCategoryController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actions() 
    {
	    return [
		'toggle' => [
		    'class' => ToggleAction::className(),
		    'modelClass' => 'backend\models\CricketCategory',
		    'attribute' => 'status',
		    // Uncomment to enable flash messages
		    'setFlash' => true,
		],
	    ];
    }
    /**
     * Lists all Catgeory models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CricketCategorySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		$model = new CricketCategory();

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
			'model' => $model,
        ]);
    }

    /**
     * Creates a new Category model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new CricketCategory();
        $searchModel = new CricketCategorySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        if($model->load(Yii::$app->request->post())) {
        $model->slug = $this->seofriendlyurl($_POST['CricketCategory']['slug']);
       	if($model->save(false))
			return $this->redirect(['index']);
		else
			return $this->render('index', [
               		 'model' => $model,
					 'searchModel' => $searchModel,
			         'dataProvider' => $dataProvider,
			]);

            } else {
            return $this->render('index', [
                'model' => $model,'searchModel' => $searchModel,'dataProvider' => $dataProvider,
            ]);
            }
    }

    /**
     * Updates an existing Category model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
   public function actionUpdate($id)
    {
        $model = $this->findModel($id);
	    $searchModel = new CricketCategorySearch();
		
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        if ($model->load(Yii::$app->request->post())) {
        $model->slug = $this->seofriendlyurl($_POST['CricketCategory']['slug']);
		if($model->save(false))
			return $this->redirect(['index']);
		else
			return $this->render('index', [
               		 'model' => $model,
					 'searchModel' => $searchModel,
			         'dataProvider' => $dataProvider,
			]);
        } else {
            return $this->render('index', [
                'model' => $model,
				'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }
    }
	
	public function actionDelete($id)
    {
		$package = Cricket::find()->where('cat_id='.$id.' AND status=1')->exists();
		if($package)
		{
			$err_msg = 'Cricket';
		}
		else
		{
			$err_msg = '';
		}

		if(!empty($err_msg))
			throw new HttpException(400,'You can not delete this record because it is used in '.$err_msg.' table.');
		else  {
			$this->findModel($id)->delete();
		}

		return $this->redirect(['index']);
    }
    

    /**
     * Finds the Category model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Category the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = CricketCategory::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
	public function seofriendlyurl($string){
		$string = str_replace(array('[\', \']'), '', $string);
		$string = preg_replace('/\[.*\]/U', '', $string);
		$string = preg_replace('/&(amp;)?#?[a-z0-9]+;/i', '-', $string);
		$string = htmlentities($string, ENT_COMPAT, 'utf-8');
		$string = preg_replace('/&([a-z])(acute|uml|circ|grave|ring|cedil|slash|tilde|caron|lig|quot|rsquo);/i', '\\1', $string );
		$string = preg_replace(array('/[^a-z0-9]/i', '/[-]+/') , '-', $string);
		return strtolower(trim($string, '-'));
   }
    
}
