<?php

namespace backend\controllers;

use yii\web\Controller;
use yii\filters\VerbFilter;

/**
 * ClientController implements the CRUD actions for Client model.
 */
class DashboardController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Client models.
     * @return mixed
     */
    public function actionIndex() {
		$this->layout = 'homePage';
		$total_contact = \frontend\models\ContactUs::find()->Where(['status' => 1])->all();
		return $this->render('index', [
                    'total_contact' => $total_contact,
        ]);
    }

}
