<?php

namespace backend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use frontend\models\NewsComments;
use frontend\models\NewsCommentsSearch;
use yii\web\Response;


class NewsCommentsController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all SubscribeSubscribers models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new NewsCommentsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
	
	 public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        if ($model->load(Yii::$app->request->post())) {
            //$data=Yii::$app->request->post();
			// print_r(json_encode($data));
			// exit;
			$model->status = $_POST['NewsComments']['status'];
			$model->save(false);
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }
	
	 public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

public function actionDeleteselected(){
		$select = Yii::$app->request->post('selection'); //checkbox (array)
		foreach($select as $id){
			$this->findModel($id)->delete();
		}
		return $this->redirect(['index']);
	 }
	
	protected function findModel($id)
    {
        if (($model = NewsComments::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
