<?php
namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\Post;
use backend\models\PostSearch;
use backend\models\UploadForm;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Gd;
use Imagine\Image\Box;
use Imagine\Image\BoxInterface;
use Imagine\Image\ManipulatorInterface;

class PostController extends Controller
{
    /**
     * @inheritdoc
     */
     
    public $enableCsrfValidation = false;
    
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
    /**
     * Lists all Post models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new PostSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    

    /**
     * Creates a new Post model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Post();
        if ($model->load(Yii::$app->request->post())) {
			if ($_FILES['Post']['name']['image'] != '') {
                $uploadFile = UploadedFile::getInstance($model, 'image');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->image = $fileName;
                $uploadFile->saveAs('images/post/big/' . $fileName);
                $uploadFile->saveAs('images/post/small/' . $fileName);
            }
            if ($_FILES['Post']['name']['image'] == '') {
                $model->image = '';
            }
			
			if ($_FILES['Post']['name']['thumbnail'] != '') {
                $uploadFilee = UploadedFile::getInstance($model, 'thumbnail');

                $random_digit = rand(0000, 9999);
                $fileNamee = $random_digit . "_{$uploadFilee}";
                $model->thumbnail = $fileNamee;
                $uploadFilee->saveAs('images/post/thumbnail/' . $fileNamee);
            }
            if ($_FILES['Post']['name']['thumbnail'] == '') {
                $model->thumbnail = '';
            }
			
			if($model->tag_id != '') {
             $model->setTagArray($model->tag_id);
            }
if($model->weekend_id != '') {
             $model->setPostArray($model->weekend_id);
            }
			$model->slug = $this->seofriendlyurl($_POST['Post']['slug']);
			$model->save(false);
            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Post model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $old_img = $model->image;
		$old_thumbnail = $model->thumbnail;
		$model->tag_id = explode(',', $model->tag_id);
$model->weekend_id = explode(',', $model->weekend_id);
        if ($model->load(Yii::$app->request->post())) {
			if ($_FILES['Post']['name']['image'] != '') {
                
                $uploadFile = UploadedFile::getInstance($model, 'image');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->image = $fileName;
                $uploadFile->saveAs('images/post/big/' . $fileName);
                $uploadFile->saveAs('images/post/small/' . $fileName);
              }
            if ($_FILES['Post']['name']['image'] == '') {
                $model->image = $old_img;
            }
			
			if ($_FILES['Post']['name']['thumbnail'] != '') {
                
                $uploadFilee = UploadedFile::getInstance($model, 'thumbnail');

                $random_digit = rand(0000, 9999);
                $fileNamee = $random_digit . "_{$uploadFilee}";
                $model->thumbnail = $fileNamee;
                $uploadFilee->saveAs('images/post/thumbnail/' . $fileNamee);
              }
            if ($_FILES['Post']['name']['thumbnail'] == '') {
                $model->thumbnail = $old_thumbnail;
            }
			
if($model->tag_id != '') {
			$model->setTagArray($model->tag_id);
}
if($model->weekend_id != '') {
             $model->setPostArray($model->weekend_id);
            }
			$model->slug = $this->seofriendlyurl($_POST['Post']['slug']);
            $model->save(false);
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    public function actionDelete($id)
    {
		$this->findModel($id)->delete();
		return $this->redirect(['index']);
    }
    
    
    public function actionUpload() {
		$model = new UploadForm();

		if (Yii::$app->request->isPost) {
            $model->file = UploadedFile::getInstanceByName('file');
            $random_digit = rand(0000, 9999);
            $fileName = $random_digit . "_{$model->file->baseName}";
            if ($model->file) {
                $model->file->saveAs(Yii::getAlias('@backend') . '/web/uploads/images/' . $fileName . '.' . $model->file->extension);
            }
        }

        // Get file link
        $res = array (
            'filelink'    => '/backend/web/uploads/images/' . $fileName . '.' . $model->file->extension,
        );

        // Response data
        return json_encode($res);
    }

    /**
     * Finds the Post model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Post the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Post::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
	
	public function seofriendlyurl($string){
		$string = str_replace(array('[\', \']'), '', $string);
		$string = preg_replace('/\[.*\]/U', '', $string);
		$string = preg_replace('/&(amp;)?#?[a-z0-9]+;/i', '-', $string);
		$string = htmlentities($string, ENT_COMPAT, 'utf-8');
		$string = preg_replace('/&([a-z])(acute|uml|circ|grave|ring|cedil|slash|tilde|caron|lig|quot|rsquo);/i', '\\1', $string );
		$string = preg_replace(array('/[^a-z0-9]/i', '/[-]+/') , '-', $string);
		return strtolower(trim($string, '-'));
   }
    
    
}
