<?php
namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\PostFaq;
use backend\models\PostFaqSearch;
use backend\models\UploadForm;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;

class PostFaqController extends Controller
{
    /**
     * @inheritdoc
     */
     
    public $enableCsrfValidation = false;
    
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }
    /**
     * Lists all PostFaq models.
     * @return mixed
     */
    public function actionIndex($id)
    {
        $searchModel = new PostFaqSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams, $id);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
			'ptid' => $id,
        ]);
    }

    

    /**
     * Creates a new PostFaq model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new PostFaq();

        if ($model->load(Yii::$app->request->post())) {
             $connection = Yii::$app->getDb();    
             $commandd = $connection->createCommand('select * from post where id='.$id)->queryOne();
$connection->close();
			 $model->post_id = $id;
			 $model->save(false);
            return $this->redirect(['index','id' => $id]);
        } else {
            return $this->render('create', [
                'model' => $model,
                'magid' => $id,
            ]);
        }
    }

    /**
     * Updates an existing PostFaq model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
           $model->save();
             return $this->redirect(['index','id' => $model->post_id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'postid' => $model->post_id,
            ]);
        }
    }

    public function actionDelete($id)
    {
		$this->findModel($id)->delete();
		return $this->redirect(['index']);
    }

    /**
     * Finds the PostFaq model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return PostFaq the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PostFaq::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    
}
