<?php
namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use frontend\models\ContactUs;
use yii\web\UploadedFile;
use yii\web\Response;
/**
 * Site controller
 */
class SiteController extends Controller
{
    public $enableCsrfValidation = false;
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['logout', 'index', 'upload-image'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    
    public function actionUploadImage()
    {
        Yii::$app->response->format = Response::FORMAT_JSON;

        $uploadedFile = UploadedFile::getInstanceByName('file');

        if ($uploadedFile) {

            $uploadPath = Yii::getAlias('@backend/web/uploads/images/');
            
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            $fileName = time() . '_' . $uploadedFile->baseName . '.' . $uploadedFile->extension;

            if ($uploadedFile->saveAs($uploadPath . $fileName)) {
                return [
                    'location' => Yii::$app->request->baseUrl . '/uploads/images/' . $fileName
                ];
            }
        }

        return ['error' => 'Image upload failed'];
    }


    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {
       $this->layout = 'homePage';
		$total_contact = ContactUs::find()->Where(['status' => 1])->all();
        return $this->render('index', [
                    'total_contact' => $total_contact,
        ]);
    }

    /**
     * Login action.
     *
     * @return string
     */
    public function actionLogin()
    {
         $model = \Yii::createObject(LoginForm::className());

        $this->performAjaxValidation($model);

        if ($model->load(\Yii::$app->getRequest()->post()) && $model->login()) {
			$log = new UserLog();
            $log->loger();
			if (Yii::$app->user->identity->role == 'webuser') {
				return $this->redirect(['/']);
            } else {
				return $this->redirect(['/dashboard']);
            }
        }


        return $this->render('login', [
                    'model' => $model,
                    'module' => $this->module,
        ]);
    }

    /**
     * Logout action.
     *
     * @return string
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }
}
