<?php
namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\Slider;
use backend\models\SliderSearch;
use backend\models\Menu;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Gd;
use Imagine\Image\Box;
use Imagine\Image\BoxInterface;
use Imagine\Image\ManipulatorInterface;

/**
 * SliderController implements the CRUD actions for Slider model.
 */
class SliderController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Slider models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SliderSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    

    /**
     * Creates a new Slider model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Slider();
        if ($model->load(Yii::$app->request->post())) {
			if ($_FILES['Slider']['name']['file'] != '') {
				$uploadFile = UploadedFile::getInstance($model, 'file');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->file = $fileName;
                $uploadFile->saveAs(Yii::getAlias('@backend') . '/web/images/slider/' . $fileName);
				
                //$uploadFile = UploadedFile::getInstance($model, 'file');

                //$random_digit = rand(0000, 9999);
                //$fileName = $random_digit . "_{$uploadFile}";
                //$model->file = $fileName;
                //$uploadFile->saveAs('images/' . $fileName);
                
                //Image::resize(Yii::getAlias('@backend') . '/web/images/' . $fileName,1550,600,false,false)->save(Yii::getAlias('@backend') . '/web/images/slider/' . $fileName, ['quality' => 70]);
                        
                //unlink(Yii::getAlias('@backend') . '/web/images/' . $fileName);	        
            }
            if ($_FILES['Slider']['name']['file'] == '') {
                $model->file = '';
            }
			$model->save(false);
            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Slider model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $old_img = $model->file;
        if ($model->load(Yii::$app->request->post())) {
			if ($_FILES['Slider']['name']['file'] != '') {
                if ($old_img != ''):
                    unlink(Yii::getAlias('@backend') . '/web/images/slider/' . $old_img);
                endif;
                $uploadFile = UploadedFile::getInstance($model, 'file');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->file = $fileName;
                $uploadFile->saveAs('images/' . $fileName);
                Image::resize(Yii::getAlias('@backend') . '/web/images/' . $fileName,1550,600,false,false)->save(Yii::getAlias('@backend') . '/web/images/slider/' . $fileName,['quality' => 70]);
                unlink(Yii::getAlias('@backend') . '/web/images/' . $fileName);	
            }
            if ($_FILES['Slider']['name']['file'] == '') {
                $model->file = $old_img;
            }
            $model->save(false);
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    public function actionDelete($id)
    {
		$model = $this->findModel($id);
        $old_img = $model->file;
		unlink(Yii::getAlias('@backend') . '/web/images/slider/' . $old_img);
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }
    

    /**
     * Finds the Slider model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slider the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Slider::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
    
    
}
