<?php
namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\Team;
use backend\models\TeamSearch;
use backend\models\UploadForm;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Gd;
use Imagine\Image\Box;
use Imagine\Image\BoxInterface;
use Imagine\Image\ManipulatorInterface;

class TeamController extends Controller
{
    /**
     * @inheritdoc
     */
    public $enableCsrfValidation = false;
	
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Team models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TeamSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Creates a new Team model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Team();
        if ($model->load(Yii::$app->request->post())) {
            if ($_FILES['Team']['name']['file'] != '') {
                $uploadFile = UploadedFile::getInstance($model, 'file');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->file = $fileName;
                $uploadFile->saveAs('images/' . $fileName);
                
                Image::resize(Yii::getAlias('@backend') . '/web/images/' . $fileName,370,370,false,false)
                ->save(Yii::getAlias('@backend') . '/web/images/team/' . $fileName, 
                        ['quality' => 70]);
                        
                unlink(Yii::getAlias('@backend') . '/web/images/' . $fileName);	        
            }
            if ($_FILES['Team']['name']['file'] == '') {
                $model->file = '';
            }
			$model->save(false);
            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Team model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $old_img = $model->file;
		if ($model->load(Yii::$app->request->post())) {
		    if ($_FILES['Team']['name']['file'] != '') {
                if ($old_img != ''):
                    unlink(Yii::getAlias('@backend') . '/web/images/team/' . $old_img);
                endif;
                $uploadFile = UploadedFile::getInstance($model, 'file');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->file = $fileName;
                $uploadFile->saveAs('images/' . $fileName);
                
                Image::resize(Yii::getAlias('@backend') . '/web/images/' . $fileName,370,370,false,false)
                ->save(Yii::getAlias('@backend') . '/web/images/team/' . $fileName, 
                        ['quality' => 70]);
                        
                unlink(Yii::getAlias('@backend') . '/web/images/' . $fileName);	  
            }
            if ($_FILES['Team']['name']['file'] == '') {
                $model->file = $old_img;
            }
			$model->save(false);
            return $this->redirect(['index']);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    public function actionDelete($id)
    {
		$model = $this->findModel($id);
        $old_img = $model->file;
        if($old_img != '') {
		 unlink(Yii::getAlias('@backend') . '/web/images/team/' . $old_img);
        }
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }
    
    
    /**
     * Finds the Team model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Team the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Team::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
