<?php
namespace backend\controllers;

use Yii; 
use yii\web\Controller;
use backend\models\UserBlog;
use backend\models\UserBlogSearch;
use backend\models\City;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;
use pheme\grid\actions\ToggleAction;
use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Gd;
use Imagine\Image\Box;
use Imagine\Image\BoxInterface;
use Imagine\Image\ManipulatorInterface;

class UserBlogController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actions() 
    {
	    return [
		'toggle' => [
		    'class' => ToggleAction::className(),
		    'modelClass' => 'backend\models\UserBlog',
		    'attribute' => 'status',
		    // Uncomment to enable flash messages
		    'setFlash' => true,
		],
	    ];
    }
    /**
     * Lists all UserBlog models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new UserBlogSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
		$model = new UserBlog();

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
			'model' => $model,
        ]);
    }

    /**
     * Creates a new UserBlog model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new UserBlog();
        $searchModel = new UserBlogSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        if($model->load(Yii::$app->request->post())) {
       	if($model->save(false))
			return $this->redirect(['index']);
		else
			return $this->render('index', [
               		 'model' => $model,
					 'searchModel' => $searchModel,
			         'dataProvider' => $dataProvider,
			]);

            } else {
            return $this->render('index', [
                'model' => $model,'searchModel' => $searchModel,'dataProvider' => $dataProvider,
            ]);
            }
    }

    /**
     * Updates an existing UserBlog model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
   public function actionUpdate($id)
    {
        $model = $this->findModel($id);
	    $searchModel = new UserBlogSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        if ($model->load(Yii::$app->request->post())) {
		if($model->save(false))
			return $this->redirect(['index']);
		else
			return $this->render('index', [
               		 'model' => $model,
					 'searchModel' => $searchModel,
			         'dataProvider' => $dataProvider,
			]);
        } else {
            return $this->render('index', [
                'model' => $model,
				'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }
    }
    
    public function actionDelete($id)
    {
		$this->findModel($id)->delete();
		return $this->redirect(['index']);
    }
	
    /**
     * Finds the UserBlog model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return UserBlog the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = UserBlog::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
   
    
}
