<?php
namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\BlogFaq;


class BlogFaqSearch extends BlogFaq
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'blog_id', 'create_on', 'update_by', 'status'], 'integer'],
            [['question', 'answer', 'create_on', 'update_on'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params, $id)
    {
        $query = BlogFaq::find()->where(['blog_id' => $id]);

        // add conditions that should always apply here
       $query->joinWith(['contentblog']);
       $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 20,
            ],
            'sort' => [
                'defaultOrder' => [
                    'id' => SORT_DESC,
                ]
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
			'blog_id' => $this->blog_id,
			'create_on' => $this->create_on,
            'create_by' => $this->create_by,
            'update_on' => $this->update_on,
            'update_by' => $this->update_by,
            'status' => $this->status,
        ]);

        $query->andFilterWhere(['like', 'question', $this->question]);

    	return $dataProvider;
    }
    
}
