<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;

class Category extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'category';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'slug','heading', 'create_on', 'introduction', 'create_by'], 'required', 'message' => ''],
            [['name', 'slug', 'introduction', 'meta_title', 'meta_keyword', 'meta_description', 'create_on', 'update_on','heading'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status'], 'integer', 'message' => ''],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
			'name' => Yii::t('app', 'Category Name'),
'heading' => Yii::t('app', 'Category Heading'),
			'slug' => Yii::t('app', 'Slug'),
			'introduction' => Yii::t('app', 'Introduction'),
			'meta_title' => Yii::t('app', 'Meta Title'),
            'meta_keyword' => Yii::t('app', 'Meta Keyword'),
            'meta_description' => Yii::t('app', 'Meta Description'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }
    
    public function limitTextWords($content = false, $limit = false, $stripTags = false, $ellipsis = false) 
    {
        if ($content && $limit) {
            $content = ($stripTags ? strip_tags($content) : $content);
            $content = explode(' ', $content, $limit+1);
            array_pop($content);
            if ($ellipsis) {
                array_push($content, '...');
            }
            $content = implode(' ', $content);
        }
        return $content;
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
        return parent::beforeSave($insert);
    }
}
