<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;
/**
 * This is the model class for table "city".
 *
 * @property integer $id
 * @property integer $state_id
 * @property string $city_name
 * @property string $create_on
 * @property integer $create_by
 * @property string $update_on
 * @property integer $update_by
 * @property integer $status
 *
*/
class City extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'city';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['state_id', 'city_name', 'slug', 'introduction', 'create_on', 'create_by'], 'required', 'message' => ''],
            [['create_on', 'update_on', 'city_name', 'introduction', 'meta_title', 'meta_keyword', 'meta_description', 'slug'], 'safe', 'message' => ''],
            [['state_id', 'create_by', 'update_by', 'status'], 'integer', 'message' => ''],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
			'state_id' => Yii::t('app', 'State'),
            'city_name' => Yii::t('app', 'City Name'),
			'slug' => Yii::t('app', 'Slug'),
			'introduction' => Yii::t('app', 'Introduction'),
			'meta_title' => Yii::t('app', 'Meta Title'),
            'meta_keyword' => Yii::t('app', 'Meta Keyword'),
            'meta_description' => Yii::t('app', 'Meta Description'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }
	
	public function getState()
    {
        return $this->hasOne(\backend\models\State::className(), ['id' => 'state_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
        return parent::beforeSave($insert);
    }
}
