<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;
/**
 * This is the model class for table "email_template".
 *
 * @property integer $id
 * @property string $template_name
 * @property string $email_subject
 * @property string $template
 * @property string $create_on
 * @property integer $create_by
 * @property string $update_on
 * @property integer $update_by
 * @property integer $status
 *
*/
class EmailTemplate extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'email_template';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['template_name', 'email_subject', 'template', 'create_on', 'create_by'], 'required', 'message' => ''],
            [['create_on', 'update_on'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status'], 'integer', 'message' => ''],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
            'template_name' => Yii::t('app', 'Template Name'),
            'email_subject' => Yii::t('app', 'Subject'),
			'template' => Yii::t('app', 'Template'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
        return parent::beforeSave($insert);
    }
}
