<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\FamousPlaces;

class FamousPlacesSearch extends FamousPlaces
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'create_on', 'update_by', 'status'], 'integer'],
            [['famous_place_name', 'introduction', 'meta_title', 'meta_keyword', 'meta_description', 'slug', 'post_id', 'create_on', 'update_on'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = FamousPlaces::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query, 'sort'=> ['defaultOrder' => ['id'=>SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
			'create_on' => $this->create_on,
            'create_by' => $this->create_by,
            'update_on' => $this->update_on,
            'update_by' => $this->update_by,
            'status' => $this->status,
        ]);

        $query->andFilterWhere(['like', 'famous_place_name', $this->famous_place_name]);

        return $dataProvider;
    }
}
