<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;

class Menu extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'menu';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['category_id', 'create_on', 'create_by'], 'required', 'message' => ''],
            [['create_on', 'update_on', 'tag_id'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status', 'category_id'], 'integer', 'message' => ''],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
			'category_id' => Yii::t('app', 'Category'),
			'tag_id' => Yii::t('app', 'Tag'),
			'meta_description' => Yii::t('app', 'Meta Description'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }
	
	 public function blogtag($tag_id)
    { 
        $connection = Yii::$app->getDb();
		$result = $connection->createCommand("SELECT * FROM tag where id=".$tag_id." AND status = 1")->queryOne();
		return $result['name'];
    }
	
	public function setTagArray(array $value)
    {
        $this->tag_id = implode(',', $value);
    }

	
	public function getCategory()
    {
        return $this->hasOne(\backend\models\Category::className(), ['id' => 'category_id']);
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        return parent::beforeSave($insert);
    }
}
