<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;
use backend\models\MovieCategory;

class Movie extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'movie';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['heading', 'slug', 'content', 'cat_id', 'create_on', 'create_by', 'status'], 'required', 'message' => ''],
            [['meta_title', 'meta_keyword', 'meta_description', 'create_on', 'update_on', 'image'], 'safe', 'message' => ''],
            [['cat_id', 'create_by', 'update_by', 'status', 'blog_view'], 'integer', 'message' => ''],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
            'heading' => Yii::t('app', 'Heading'),
			'slug' => Yii::t('app', 'Slug'),
'image' => Yii::t('app', 'Movie Image'),
			'content' => Yii::t('app', 'Content'),
			'cat_id' => Yii::t('app', 'Category Name'),
			'meta_title' => Yii::t('app', 'Meta Title'),
			'meta_keyword' => Yii::t('app', 'Meta Keyword'),
			'meta_description' => Yii::t('app', 'Meta Description'),
'blog_view' => Yii::t('app', 'Total View'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }
	
	public function getCategory() {
        return $this->hasOne(MovieCategory::className(), ['id' => 'cat_id']);
    }
	
	public function setTagArray(array $value)
    {
        $this->tag_id = implode(',', $value);
    }

public function getCreatedBy()
    {
        return $this->hasOne(User::className(), ['id' => 'create_by']);
    }

   public function limitTextWords($content = false, $limit = false, $stripTags = false, $ellipsis = false) 
    {
        if ($content && $limit) {
            $content = ($stripTags ? strip_tags($content) : $content);
            $content = explode(' ', $content, $limit+1);
            array_pop($content);
            if ($ellipsis) {
                array_push($content, '...');
            }
            $content = implode(' ', $content);
        }
        return $content;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        /*if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }*/
        return parent::beforeSave($insert);
    }
}
