<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;
use backend\models\Post;

class PopularTab extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'popular_tab';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['post_id', 'create_on', 'create_by', 'category_id'], 'required', 'message' => ''],
            [['post_id', 'create_on', 'update_on', 'category_id'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status', 'state_id', 'city_id'], 'integer', 'message' => ''],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
			'post_id' => Yii::t('app', 'Post'),
            'category_id' => Yii::t('app', 'Category'),
			'state_id' => Yii::t('app', 'State'),
			'city_id' => Yii::t('app', 'City'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }
	
	 public function postall($post_id)
         { 
          $result = Post::find()->where(['id' => $post_id])->AndWhere(['status' => 1])->all();
          foreach($result as $resultt) {
           return $resultt->title;
           }
          }
	
	public function setPostArray(array $value)
    {
        $this->post_id = implode(',', $value);
    }
	
	public function getState()
    {
        return $this->hasOne(\backend\models\State::className(), ['id' => 'state_id']);
    }
	
	public function getCity()
    {
        return $this->hasOne(\backend\models\City::className(), ['id' => 'city_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
        return parent::beforeSave($insert);
    }
}
