<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;

class Post extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'post';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['title', 'slug', 'content', 'category_id', 'state_id', 'city_id', 'create_on', 'create_by'], 'required', 'message' => ''],
            [['create_on', 'update_on', 'meta_title', 'meta_keyword', 'meta_description', 'slug', 'content', 'tag_id', 'weekend_id', 'image', 'thumbnail'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status', 'category_id', 'state_id', 'city_id'], 'integer', 'message' => ''],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
			'title' => Yii::t('app', 'Post Title'),
			'slug' => Yii::t('app', 'Slug'),
			'category_id' => Yii::t('app', 'Category'),
			'tag_id' => Yii::t('app', 'Tag'),
			'content' => Yii::t('app', 'Post Content'),
			'state_id' => Yii::t('app', 'State'),
			'city_id' => Yii::t('app', 'City'),
                        'weekend_id' => Yii::t('app', 'Weekend Post'),
'thumbnail' => Yii::t('app', 'Thumbnail'),
			'image' => Yii::t('app', 'Post Image'),
			'meta_title' => Yii::t('app', 'Meta Title'),
            'meta_keyword' => Yii::t('app', 'Meta Keyword'),
            'meta_description' => Yii::t('app', 'Meta Description'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }
	
	 public function blogtag($tag_id)
    { 
        $connection = Yii::$app->getDb();
		$result = $connection->createCommand("SELECT * FROM tag where id=".$tag_id." AND status = 1")->queryOne();
		return $result['name'];
    }

public function tagslug($tag_id)
    { 
        $connection = Yii::$app->getDb();
		$result = $connection->createCommand("SELECT * FROM tag where id=".$tag_id." AND status = 1")->queryOne();
		return $result['slug'];
    }
	
	public function setTagArray(array $value)
    {
        $this->tag_id = implode(',', $value);
    }

   public function blogPost($weekend_id)
    { 
        $connection = Yii::$app->getDb();
		$result = $connection->createCommand("SELECT * FROM post where id=".$weekend_id." AND status = 1")->queryOne();
		return $result['name'];
    }
	
	public function setPostArray(array $value)
    {
        $this->weekend_id = implode(',', $value);
    }
	
	public function getState()
    {
        return $this->hasOne(\backend\models\State::className(), ['id' => 'state_id']);
    }
	
	public function getCity()
    {
        return $this->hasOne(\backend\models\City::className(), ['id' => 'city_id']);
    }
	
	public function getCategory()
    {
        return $this->hasOne(\backend\models\Category::className(), ['id' => 'category_id']);
    }
	
	public function limitTextWords($content = false, $limit = false, $stripTags = false, $ellipsis = false) 
    {
        if ($content && $limit) {
            $content = ($stripTags ? strip_tags($content) : $content);
            $content = explode(' ', $content, $limit+1);
            array_pop($content);
            if ($ellipsis) {
                array_push($content, '...');
            }
            $content = implode(' ', $content);
        }
        return $content;
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
		if (isset($this->title) && $this->title != '') {
            $this->title = ucwords($this->title);
        }
        return parent::beforeSave($insert);
    }
}
