<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;
/**
 * This is the model class for table "slider".
 *
 * @property integer $id
 * @property string $heading
 * @property string $sub_heading
 * @property string $nav_heading
 * @property string $short_content
 * @property string $link
 * @property string $file
 * @property string $create_on
 * @property integer $create_by
 * @property string $update_on
 * @property integer $update_by
 * @property integer $status
 *
*/
class Slider extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'slider';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['heading', 'link', 'create_on', 'create_by'], 'required', 'message' => ''],
            [['create_on', 'update_on'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status'], 'integer', 'message' => ''],
			[['short_content'], 'string', 'max' => 200],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
            'heading' => Yii::t('app', 'Heading'),
            'sub_heading' => Yii::t('app', 'Sub Heading'),
			'short_content' => Yii::t('app', 'Content'),
            'nav_heading' => Yii::t('app', 'Navigation Heading'),
			'link' => Yii::t('app', 'Link'),
            'file' => Yii::t('app', 'Image'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
        return parent::beforeSave($insert);
    }
}
