<?php

namespace backend\models;

use Yii;
use dektrium\user\Module;
use dektrium\user\models\User;
use yii\base\Model;
use \yii\db\Expression;
/**
 * This is the model class for table "state".
 *
 * @property integer $id
 * @property integer $country_id
 * @property string $state_name
 * @property string $create_on
 * @property integer $create_by
 * @property string $update_on
 * @property integer $update_by
 * @property integer $status
 *
*/
class State extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'state';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['state_name', 'slug', 'introduction', 'create_on', 'create_by'], 'required', 'message' => ''],
            [['create_on', 'heading', 'update_on', 'meta_title', 'meta_keyword', 'meta_description', 'state_name', 'slug', 'introduction', 'image', 'brief_content', 'statement', 'google_map_link', 'introduction_city', 'meta_title_city', 'meta_keyword_city', 'meta_description_city'], 'safe', 'message' => ''],
            [['create_by', 'update_by', 'status'], 'integer', 'message' => ''],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
			'id' => Yii::t('app', 'Page ID'),
			'state_name' => Yii::t('app', 'State Name'),
			'image' => Yii::t('app', 'Image'),
			'slug' => Yii::t('app', 'Slug'),
            'heading' => Yii::t('app', 'Heading'),
			'introduction' => Yii::t('app', 'Introduction'),
            'brief_content' => Yii::t('app', 'Brief Content'),
            'statement' => Yii::t('app', 'Statement'),
            'google_map_link' => Yii::t('app', 'Google Map Link'),
			'meta_title' => Yii::t('app', 'Meta Title'),
            'meta_keyword' => Yii::t('app', 'Meta Keyword'),
            'meta_description' => Yii::t('app', 'Meta Description'),
            'introduction_city' => Yii::t('app', 'Introduction For City'),
            'meta_title_city' => Yii::t('app', 'Meta Title For City'),
            'meta_keyword_city' => Yii::t('app', 'Meta Keyword For City'),
            'meta_description_city' => Yii::t('app', 'Meta Description For City'),
            'create_on' => Yii::t('app', 'Created At'),
            'create_by' => Yii::t('app', 'Created By'),
            'create_on' => Yii::t('app', 'Updated At'),
            'update_by' => Yii::t('app', 'Updated By'),
            'status' => Yii::t('app', 'Status'),
        ];
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = \Yii::$app->user->identity->id;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = \Yii::$app->user->identity->id;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
        return parent::beforeSave($insert);
    }
}
