<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\redactor\widgets\Redactor;
use kartik\widgets\DatePicker;
?>
<div class="col-xs-12 col-lg-12">
	<div class="<?php echo $model->isNewRecord ? 'box-success' : 'box-info'; ?> box view-item col-xs-12 col-lg-12">
		<div class="daily-current-form">
		    <?php $form = ActiveForm::begin([
					'id' => 'form',
					'enableClientValidation' => true,
                'options' => ['class' => 'form-horizontal', 'enctype' => 'multipart/form-data'],
                'fieldConfig' => [
                    'template' => "{label}{input}{error}",
                ],
		    ]); ?>

			<div class="col-xs-12 col-lg-12 no-padding">
				<div class="col-xs-12 col-sm-6 col-lg-6">
				  <?= $form->field($model, 'cat_id')->dropDownList(ArrayHelper::map(\backend\models\BlogCategory::find()->where(['status' => 1])->all(),'id','category_name'), ['prompt'=>Yii::t('app', '--- Select Category Name ---') ]); ?>
				</div>
           </div>
		   <div class="col-xs-12 col-lg-12 no-padding">
				<div class="col-xs-12 col-sm-6 col-lg-6">
				  <?= $form->field($model, 'blog_user_id')->dropDownList(ArrayHelper::map(\backend\models\UserBlog::find()->where(['status' => 1])->all(),'id','name'), ['prompt'=>Yii::t('app', '--- Select User Name ---') ]); ?>
				</div>
           </div>
		    <div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
		    	<?= $form->field($model, 'heading')->textInput(['placeholder' => $model->getAttributeLabel('heading')]) ?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
		    	<div class="col-xs-12 col-sm-6 col-lg-6">
				  <?= $form->field($model, 'slug')->textInput(['placeholder' => $model->getAttributeLabel('slug')]) ?>
		    	</div>
           </div>
          <div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-8 col-lg-8">
            <?php if (!empty($model->image)) : ?>
					<?php
					echo $form->field($model, 'image')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => true,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
							'initialPreview' => [
								'<img src="/backend/web/images/blog/' . $model->image . '" class="file-preview-image">',
							],
						]
					])->label('Blog Image');
					?>
				<?php else: ?>
					<?php
					echo $form->field($model, 'image')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => true,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
						]
					])->label('Blog Image');
					?>

				<?php endif; ?>
				  </div>
			</div>
		  <div class="col-xs-12 col-lg-12 no-padding">
		    	<div class="col-xs-12 col-sm-6 col-lg-6">
				  <?= $form->field($model, 'meta_title')->textArea(['placeholder' => $model->getAttributeLabel('meta_title')]) ?>
		    	</div>
           </div>
		   <div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
		    	<?= $form->field($model, 'meta_keyword')->textArea(['placeholder' => $model->getAttributeLabel('meta_keyword')]) ?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
		    	<div class="col-xs-12 col-sm-6 col-lg-6">
				  <?= $form->field($model, 'meta_description')->textArea(['placeholder' => $model->getAttributeLabel('meta_description')]) ?>
		    	</div>
           </div>
			<div class="col-xs-12 col-lg-12 no-padding">
	    		<div class="col-xs-12 col-sm-2 col-lg-6">
	    			 <?=$form->field($model, 'content')->widget(Redactor::className(), [
							'options' => [
                						'minHeight' => 300,
                						'imageUpload' => ['/redactor/upload/image'],
                						'fileUpload' => ['redactor/upload/file'],
                						'plugins' => ['fullscreen']
                					],
                				   'clientOptions' => [
                					'imageUploadParam' => 'file',
                					'imageUpload' => \yii\helpers\Url::to(['/blog/upload']),
                					'fileUpload' => ['/redactor/upload/file'],
                					'lang' => 'en_gb',
                					'plugins' => ['clips', 'fontcolor','imagemanager']
                				  ]
						])
						?>
	    		</div>
			</div>
<div class="col-xs-12 col-lg-12 no-padding">
	    		<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?=$form->field($model, 'create_on')->widget(
            DatePicker::className(), [
        'type' => DatePicker::TYPE_INPUT,
        'options' => [
            'readonly' => true,
            'placeholder' => 'Select Date',
            'value' => $model->create_on != NULL ? Yii::$app->formatter->asDatetime($model->create_on, "php:d-m-Y") : "",
        ],
        'pluginOptions' => [
            'autoclose' => true,
            'endDate' => date("d M Y", strtotime("0 day", strtotime(date('d M Y')))),
            'todayHighlight' => true,
            'format' => 'dd-mm-yyyy'
        ],
    ]);
    ?>
	    		</div>
			</div>
            <div class="col-xs-12 col-lg-12 no-padding">
	    		<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?= $form->field($model, 'status')->radioList(['1' => 'Active', '0' => 'Inactive'], ['inline' => true]) ?>
	    		</div>
			</div>
	    	<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
				<div class="col-xs-6">
					<?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord  ? 'btn btn-block btn-success' : 'btn btn-block btn-info']) ?>
				</div>
				<div class="col-xs-6">
					<?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
				</div>
	    	</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
