<?php

use yii\helpers\Html;
use yii\grid\GridView;
use backend\models\State;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $searchModel app\modules\models\CitySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'City';
$this->params['breadcrumbs'][] = $this->title;
?>
 <?php if($model->isNewRecord) 
	echo $this->render('create', ['model' => $model]); 
   else
	echo $this->render('update', ['model' => $model]); 	
?>
<div class="col-xs-12">
  <div class="col-lg-12 col-sm-12 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> City List</h3></div>
 </div>

<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
      <div class="box-body table-responsive">
	<div class="city-index">
	<?php $visible = Yii::$app->user->can("/city/create") ? true : false; ?>
	<?php
	\yii\widgets\Pjax::begin(
	    [
		'id' => 'id',
		'enablePushState'=>false,
		'enableReplaceState' =>false,
	    ]
	); ?>
	    <?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,
		'summary'=>'',
		'columns' => [
		    ['class' => 'yii\grid\SerialColumn'],

		    'city_name',
[
			      'label' => Yii::t('app','State'),
			      'attribute' => 'state_id',
			      'value' => 'state.state_name',
			      'filter' => ArrayHelper::map(State::find()->all(), 'id', 'state_name')
		    ],
				[
			'class' => '\pheme\grid\ToggleColumn',
			'contentOptions' => ['class' => 'text-center'],
			'attribute'=>'status',
			'enableAjax' => false,
			'filter'=>['0'=>'Active', '1'=>'Inactive']
		    ],
			[
			'class' => 'yii\grid\ActionColumn',
			'template' => '{update} {delete}',
			'visible' => $visible,
		    ],
		],
	    ]); ?>
	<?php \yii\widgets\Pjax::end(); ?>
       </div>
     </div>
   </div>
</div>
