<?php

use yii\helpers\Html;
use yii\grid\GridView;
use frontend\models\ContactUs;
use frontend\models\ContactUsSearch;
use yii\helpers\Url;
use yii\widgets\Pjax;
use yii\bootstrap\Modal;

/* @var $this yii\web\View */
/* @var $searchModel app\modules\models\ContactUsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->registerJs(
"$(function() {
	$('.buttonmodall').click(function() {
		$('#MailModall').modal('show')
		.find('#MailModalContentt')
		.load($(this).attr('data-value'));
	});
});");

	yii\bootstrap\Modal::begin([
	    'header' => '<h4><i class="fa fa-tasks"></i> '.Yii::t('app', 'Contact Us Detail').'</h4>',
	    'id'=>'MailModall',
	]);
	echo '<div id="MailModalContentt"></div>';
	yii\bootstrap\Modal::end();	
	
$this->title = 'Contact Us';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="col-xs-12">
  <div class="col-lg-12 col-sm-12 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> Contact Us</h3></div>
</div>

<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
      <div class="box-body table-responsive">
	<div class="courses-index">
	<?php $visible = true; ?>
	<?php
	\yii\widgets\Pjax::begin(
	    [
		'id' => 'my-grid',
		'enablePushState'=>false,
		'enableReplaceState' =>false,
	    ]
	); ?>
<?=Html::beginForm(['deleteselected'],'post');?>
	    <?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,
		'summary'=>'',
		'columns' => [
		    ['class' => 'yii\grid\SerialColumn'],
[
				'class' => 'yii\grid\CheckboxColumn', 'checkboxOptions' => function($data) {
						return ['value' => $data->id];
					},
			  ],
            'name',
			'email',
			'contact_no',
			[
				'label' => 'Action',
				'attribute' => 'id',
				'format' => 'raw',
				'value' => function ($model) {
					    $link = '';
						$link .= Html::button(Yii::t('app', '<span class="glyphicon glyphicon-eye-open"></span> View Detail'), ['data-value' => Url::to(['contact-us/view','id'=>$model->id]), 'class' => 'btn btn-xs btn-primary buttonmodall', 'style' => 'background-color: #5cb85c;border-color:#5cb85c;padding: 5px 10px;font-size: 15px;']) . " ";
						return $link;
					},
			],
			[
'class' => 'yii\grid\ActionColumn',
'template' => '{delete}',
'visible' => $visible,
   ],
		],
	    ]); ?>
<?=Html::submitButton('Delete Selectes Rows', ['class' => 'btn btn-primary']);?>
        <?= Html::endForm();?> 
	<?php \yii\widgets\Pjax::end(); ?>
       </div>
     </div>
   </div>
</div>
