<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\redactor\widgets\Redactor;

/* @var $this yii\web\View */
/* @var $model app\modules\models\EmailTemplate */
/* @var $form yii\widgets\ActiveForm */
?>
<div class="col-xs-12 col-lg-12">
	<div class="<?php echo $model->isNewRecord ? 'box-success' : 'box-info'; ?> box view-item col-xs-12 col-lg-12">
		<div class="email-template-form">
		    <?php $form = ActiveForm::begin([
					'id' => 'email-template-form',
					'enableClientValidation' => true,
                'options' => ['class' => 'form-horizontal', 'enctype' => 'multipart/form-data'],
                'fieldConfig' => [
                    'template' => "{label}{input}{error}",
                ],
		    ]); ?>


		    <div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
		    	<?= $form->field($model, 'template_name')->textInput(['placeholder' => $model->getAttributeLabel('template_name')]) ?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
		    	<div class="col-xs-12 col-sm-6 col-lg-6">
				  <?= $form->field($model, 'email_subject')->textInput(['placeholder' => $model->getAttributeLabel('email_subject')]) ?>
		    	</div>
           </div>
			<div class="col-xs-12 col-lg-12 no-padding">
	    		<div class="col-xs-12 col-sm-2 col-lg-6">
	    			<?= $form->field($model, 'template')->widget(Redactor::className(), [
					'options' => [
						'minHeight' => 5000,
						'imageUpload' => ['/redactor/upload/image'],
						'fileUpload' => ['/redactor/upload/file'],
						'plugins' => ['fullscreen']
					]
				])
				?>
	    		</div>
			</div>

	    	<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
				<div class="col-xs-6">
					<?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord  ? 'btn btn-block btn-success' : 'btn btn-block btn-info']) ?>
				</div>
				<div class="col-xs-6">
					<?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
				</div>
	    	</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
