<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\modules\models\EmailTemplateSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Email Template';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="col-xs-12">
  <div class="col-lg-8 col-sm-8 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> Email Template List</h3></div>
  <div class="col-lg-4 col-sm-4 col-xs-12 no-padding" style="padding-top: 20px !important;">
	<div class="col-xs-4 left-padding">

	</div>
	<div class="col-xs-4 left-padding">

	</div>
	<div class="col-xs-4 left-padding">
	 <?php if(Yii::$app->user->can("/email-template/create")) { ?>
             <?= Html::a(Yii::t('app', 'ADD'), ['create'], ['class' => 'btn btn-block btn-success']) ?>
	 <?php } ?>
	</div>
  </div>
</div>

<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
      <div class="box-body table-responsive">
	<div class="courses-index">
	<?php $visible = Yii::$app->user->can("/email-template/create") ? true : false; ?>
	<?php
	\yii\widgets\Pjax::begin(
	    [
		'id' => 'id',
		'enablePushState'=>false,
		'enableReplaceState' =>false,
	    ]
	); ?>
	    <?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,
		'summary'=>'',
		'columns' => [
		    ['class' => 'yii\grid\SerialColumn'],

		    'template_name',
			'email_subject',
		   [
			'class' => 'yii\grid\ActionColumn',
			'template' => '{update} {delete}',
			'buttons' => [
				'update' => function ($url, $model) {
				        return ((Yii::$app->user->can("/email-template/update")) ? Html::a('<span class="glyphicon glyphicon-pencil" style="padding: 4px 8px;border: 1px solid #3c8dbc;margin: 0 5px;border-radius: 3px;"></span>', $url, ['title' => Yii::t('app', 'Update'),]) : '');
				    },
				'delete' => function ($url, $model) {
				        return ((Yii::$app->user->can("/email-template/delete")) ? Html::a('<span class="glyphicon glyphicon-trash" style="padding: 4px 8px;border: 1px solid #3c8dbc;margin: 0 5px;border-radius: 3px;"></span>', $url, ['title' => Yii::t('app', 'Delete'), 'data' => ['confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),'method' => 'post'],]) : '');
				    }
			],
			'visible' => $visible,
		    ],
		],
	    ]); ?>
	<?php \yii\widgets\Pjax::end(); ?>
       </div>
     </div>
   </div>
</div>
