<?php
use yii\bootstrap\Nav;
use yii\helpers\Html;
?>
<aside class="left-side sidebar-offcanvas">

    <section class="sidebar">

        <?php if (!Yii::$app->user->isGuest) : ?>
            <div class="user-panel">
                <div class="pull-left image">
                    <?php echo Html::img('@web/images/user.jpg', ['class' => 'img-circle']); ?>
                </div>
                <div class="pull-left info">
                    <p> <?= Yii::t('app', 'Welcome') ?>, <?= @Yii::$app->user->identity->username ?></p>
                </div>
            </div>
        <?php endif; ?>

        <ul class="sidebar-menu">
            <li>
                <a href="#" class="navbar-link">
                    <i class="fa fa-angle-down"></i> <span class="text-info"><?= Yii::t('app', 'Menu'); ?></span>
                </a>
            </li>
	      <?php if(Yii::$app->user->can('/dashboard/index')) {
			?>
				<li><?= Html::a('<i class="fa fa-dashboard"></i> <span>'.Yii::t('app', 'Dashboard').'</span>', ['/dashboard']); ?></li>
			<?php }
			    if(Yii::$app->user->can('/category/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-th"></i> <span>'.Yii::t('app', 'Category').'</span>', ['/category']); ?></li>
				<?php }
				 if(Yii::$app->user->can('/state/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'State').'</span>', ['/state']); ?></li>
				<?php } 
				if(Yii::$app->user->can('/state-tourism/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'State Tourism').'</span>', ['/state-tourism']); ?></li>
				<?php } 
				if(Yii::$app->user->can('/city/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'City').'</span>', ['/city']); ?></li>
				<?php } 
				if(Yii::$app->user->can('/tag/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Tag').'</span>', ['/tag']); ?></li>
				<?php }
				if(Yii::$app->user->can('/post/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-th"></i> <span>'.Yii::t('app', 'Post').'</span>', ['/post']); ?></li>
				<?php }
				if(Yii::$app->user->can('/famous-places/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Famous Places').'</span>', ['/famous-places']); ?></li>
<?php }
if(Yii::$app->user->can('/weekend-gateway/index')) {
				?>
				  <li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Weekend Gateway').'</span>', ['/weekend-gateway']); ?></li>
				<?php }
if(Yii::$app->user->can('/popular-tab/index')) {
				?>
				  <li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Popular Tab').'</span>', ['/popular-tab']); ?></li>
				<?php }
				if(Yii::$app->user->can('/top-places/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Top Places').'</span>', ['/top-places']); ?></li>
                             <?php }
				if(Yii::$app->user->can('/blog/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Blog').'</span>', ['/blog']); ?></li>
<?php }
if(Yii::$app->user->can('/story/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Web Story').'</span>', ['/story']); ?></li>
<?php }
if(Yii::$app->user->can('/news/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'News').'</span>', ['/news']); ?></li>
<?php }
if(Yii::$app->user->can('/cricket/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Cricket').'</span>', ['/cricket']); ?></li>
<?php }
if(Yii::$app->user->can('/movie/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Movie').'</span>', ['/movie']); ?></li>
<?php }
			    if(Yii::$app->user->can('/slider/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-th"></i> <span>'.Yii::t('app', 'Slider').'</span>', ['/slider']); ?></li>
				<?php }
				
				if(Yii::$app->user->can('/contact-us/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Contact Us').'</span>', ['/contact-us']); ?></li>
				<?php }
				if(Yii::$app->user->can('/email-template/index')) {
				?>
					<li><?= Html::a('<i class="fa fa-list"></i> <span>'.Yii::t('app', 'Email Template').'</span>', ['/email-template']); ?></li>
				<?php } ?>
        </ul>

	<!-- sidebar-menu. -- End -->

    </section>

</aside>
