<?php
use yii\helpers\Html;
?>

<ul class="dropdown-menu" style="<?= (Yii::$app->language == 'ar') ? 'left: 0 !important; right: auto !important;' : '';?>">
    <li>
        <ul class="menu">
			<?php if(Yii::$app->user->can('Configuration')) : ?>
            <li>
				<?= Html::a('<i class="fa fa-cogs text-aqua fa-2x"></i><h4> '.Yii::t('app', 'Configuration').'</h4>', ['/organization/index']);?>
            </li>
			<?php endif; ?>
			<?php if(Yii::$app->user->can('/dashboard/default/index')) : ?>
            <li>
				<?= Html::a('<i class="fa fa-dashboard text-green fa-2x"></i> <h4>'.Yii::t('dash', 'Dashboard').'</h4>', ['/']);?>
            </li>
			<?php endif; ?>
			<?php if(Yii::$app->user->can('/employee/default/index')) : ?>
            <li>
				<?= Html::a('<i class="fa fa-users text-purple fa-2x"></i> <h4>'.Yii::t('emp', 'Employee').'</h4>', ['/employee/default/index']);?>
            </li>
			<?php endif; ?>
			<?php if(Yii::$app->user->can('/lead/default/index')) : ?>
            <li>
				<?= Html::a('<i class="fa fa-user text-purple fa-2x"></i> <h4>'.Yii::t('lead', 'Lead').'</h4>', ['/lead/default/index']);?>
            </li>
			<?php endif; ?>
			<?php if(Yii::$app->user->can('Setting')) : ?>
            <li>
			    <?php if(Yii::$app->user->can('/products/products/index')) { ?>
				   <?= Html::a('<i class="fa fa-users"></i> <span>'.Yii::t('app', 'Setting').'</span> <i class="fa fa-angle-left pull-right"></i>', [''])  ?>
				    <ul class="treeview-menu">
					  <?= Html::a('<i class="fa fa-users"></i> <span>'.Yii::t('app', 'Product').'</span>', ['/products/products/index']);?>
					 </ul> 
				<?php } else { 
					 $empSession = Yii::$app->session->get('emp_id'); 
					 $EmpMaster = app\modules\employee\models\EmpMaster::find()->andWhere(['emp_master_id' => $empSession])->one(); 
					?>
					<?= Html::a('<i class="fa fa-users"></i> <span>'.Yii::t('app', 'Setting').'</span> <i class="fa fa-angle-left pull-right"></i>', [''])  ?>
					 <ul class="treeview-menu">
					  <?= Html::a('<i class="fa fa-users"></i> <span>'.Yii::t('app', 'Profile').'</span>', ['/employee/emp-master/view', 'id' => $EmpMaster->emp_master_id]);?>
					  </ul>
				<?php } ?> 
            </li>
			<?php endif; ?>
        </ul>
    </li>
</ul>
