<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;

$this->title = 'Menu';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="col-xs-12">
  <div class="col-lg-8 col-sm-8 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> Menu List</h3></div>
  <div class="col-lg-4 col-sm-4 col-xs-12 no-padding" style="padding-top: 20px !important;">
	<div class="col-xs-4 left-padding">

	</div>
	<div class="col-xs-4 left-padding">

	</div>
	<div class="col-xs-4 left-padding">
	 <?php if(Yii::$app->user->can("/menu/create")) { ?>
             <?= Html::a(Yii::t('app', 'ADD'), ['create'], ['class' => 'btn btn-block btn-success']) ?>
	 <?php } ?>
	</div>
  </div>
</div>

<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
      <div class="box-body table-responsive">
	<div class="courses-index">
	<?php $visible = Yii::$app->user->can("/menu/create") ? true : false; ?>
	<?php
	\yii\widgets\Pjax::begin(
	    [
		'id' => 'id',
		'enablePushState'=>false,
		'enableReplaceState' =>false,
	    ]
	); ?>
	    <?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,
		'summary'=>'',
		'columns' => [
		    ['class' => 'yii\grid\SerialColumn'],

		   [
			'label' => Yii::t('app', 'Category'),
			'attribute' => 'catname',
			'value' => function ($model) {
				return $model->category->name != NULL ? $model->category->name : "Nil";
			 },
		    ],
			[
			 'attribute'=>'tag_id',
			 'headerOptions' => ['style' => 'width:20%'],
			 'format' => 'raw',
                         'filter' => ArrayHelper::map(\backend\models\Tag::find()->orderBy('name')->where(['status' => 1])->all(), 'id', 'name'),
			 'value' => function ($model) {
                                    if($model->tag_id != '') {
					$output = '';
					foreach(explode(',', $model->tag_id) as $row) {
						$output .= $model->blogtag($row)."<br />";
					}
					return $output;
                                 } else {
                                        return 'NULL';
                                  }
				},
			 ],
		   [
			'class' => 'yii\grid\ActionColumn',
			'template' => '{update} {delete}',
			'visible' => $visible,
		    ],
		],
	    ]); ?>
	<?php \yii\widgets\Pjax::end(); ?>
       </div>
     </div>
   </div>
</div>
