<?php

use yii\helpers\Html;
use yii\grid\GridView;
use frontend\models\NewsComments;
use frontend\models\NewsCommentsSearch;
use yii\helpers\Url;
use yii\widgets\Pjax;
use yii\bootstrap\Modal;


$this->title = 'News Comments';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="col-xs-12">
  <div class="col-lg-12 col-sm-12 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> News Comments</h3></div>
</div>

<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
      <div class="box-body table-responsive">
	<div class="courses-index">
	<?php $visible = true; ?>
	<?php
	\yii\widgets\Pjax::begin(
	    [
		'id' => 'my-grid-comt',
		'enablePushState'=>false,
		'enableReplaceState' =>false,
	    ]
	); ?>
<?=Html::beginForm(['deleteselected'],'post');?>
	    <?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,
		'summary'=>'',
		'columns' => [
		    ['class' => 'yii\grid\SerialColumn'],
[
				'class' => 'yii\grid\CheckboxColumn', 'checkboxOptions' => function($data) {
						return ['value' => $data->id];
					},
			  ],
            'name',
			'email',
			[
				'attribute' => 'news_id',
				'value' => function ($model) {
					return $model->uspackage->heading;
				},
				'format' => 'html',
			],
			[
				'attribute' => 'parent_id',
				'value' => function ($model) {
				    if($model->parent_id == '') {
					  return 'No reply';
				    } else {
				      return 'In reply to '.$model->commenttt->name;  
				    }
				},
				'format' => 'html',
			],
			'comment',
		    [
            'header' => 'Date',
            'attribute' => 'create_on',
            'filter' => '',
            'value' => function ($model) {
                return Yii::$app->formatter->asDate($model->create_on, 'dd-MM-yyyy');
            },
                    'contentOptions' => ['style' => 'width: 100px;']
                ],
                	[
                'attribute' => 'status',
                'format' => 'html',
                'filter' => ['1' => 'Active', '0' => 'Inactive'],
                'value' => function ($model) {
            if ($model->status === 1) {
                $text = 'Active';
                $class = 'label-success';
            } elseif ($model->status === 0) {
                $text = 'Inactive';
                $class = 'label-danger';
            }

            return '<span class="label ' . $class . '">' . $text . '</span>';
        },
                'contentOptions' => ['style' => 'width: 100px;']
            ],
		     [
            'header' => 'Action',
            'class' => 'yii\grid\ActionColumn',
            'template' => '{update}{delete}',
            'buttons' => [
                'update' => function ($url, $model) {
                       return Html::a('<span class="glyphicon glyphicon-pencil" style="padding: 4px 8px;border: 1px solid #3c8dbc;margin: 0 5px;border-radius: 3px;"></span>', ['/news-comments/update', 'id' => $model->id], [
                                    'title' => Yii::t('app', 'Update'),
                                    'data-pjax' => "0",
                        ]);
                }
                    ],
                    'contentOptions' => ['style' => 'width: 100px;']
                ],
		],
	    ]); ?>
<?=Html::submitButton('Delete Selectes Rows', ['class' => 'btn btn-primary']);?>
        <?= Html::endForm();?> 
	<?php \yii\widgets\Pjax::end(); ?>
       </div>
     </div>
   </div>
</div>
