<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\redactor\widgets\Redactor;
use yii\helpers\Url;
?>
<div class="col-xs-12 col-lg-12">
	<div class="<?php echo $model->isNewRecord ? 'box-success' : 'box-info'; ?> box view-item col-xs-12 col-lg-12">
		<div class="post-form">
		    <?php $form = ActiveForm::begin([
					'id' => 'post-form',
					'enableClientValidation' => true,
                'options' => ['class' => 'form-horizontal', 'enctype' => 'multipart/form-data'],
                'fieldConfig' => [
                    'template' => "{label}{input}{error}",
                ],
		    ]); ?>


		    <div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-8 col-lg-8">
		    	<?= $form->field($model, 'heading')->textInput(['placeholder' => $model->getAttributeLabel('heading')]) ?>
				</div>
		    </div>
			
			<div class="col-xs-12 col-lg-12 no-padding">
	    		<div class="col-xs-12 col-sm-8 col-lg-8">
	    			<?=$form->field($model, 'content')->widget(Redactor::className(), [
					'options' => [
						'minHeight' => 300,
						'imageUpload' => ['/redactor/upload/image'],
						'fileUpload' => ['redactor/upload/file'],
						'plugins' => ['fullscreen']
					],
				   'clientOptions' => [
					'imageUploadParam' => 'file',
					'imageUpload' => \yii\helpers\Url::to(['/post/upload']),
					'fileUpload' => ['/redactor/upload/file'],
					'lang' => 'en_gb',
					'plugins' => ['clips', 'fontcolor','imagemanager']
				]
				])
				?>
				</div>
			</div>
			 <?php if (!$model->isNewRecord): ?>
				<div class="col-xs-12 col-lg-12 no-padding">
					<div class="col-xs-12 col-sm-6 col-lg-6">
					   <?= $form->field($model, 'status')->radioList(['1' => 'Active', '0' => 'Inactive'], ['inline' => true]) ?>
					</div>
				</div>
             <?php endif; ?>
	    	<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
				<div class="col-xs-6">
					<?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord  ? 'btn btn-block btn-success' : 'btn btn-block btn-info']) ?>
				</div>
				<div class="col-xs-6">
					<?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
				</div>
	    	</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
