<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\redactor\widgets\Redactor;

/* @var $this yii\web\View */
/* @var $model app\modules\models\slider */
/* @var $form yii\widgets\ActiveForm */
?>
<div class="col-xs-12 col-lg-12">
	<div class="<?php echo $model->isNewRecord ? 'box-success' : 'box-info'; ?> box view-item col-xs-12 col-lg-12">
		<div class="slider-form">
		    <?php $form = ActiveForm::begin([
					'id' => 'slider-form',
					'enableClientValidation' => true,
                'options' => ['class' => 'form-horizontal', 'enctype' => 'multipart/form-data'],
                'fieldConfig' => [
                    'template' => "{label}{input}{error}",
                ],
		    ]); ?>
            <div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
		    	<?= $form->field($model, 'heading')->textArea(['placeholder' => $model->getAttributeLabel('heading')]) ?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
		    	<?= $form->field($model, 'short_content')->textArea(['placeholder' => $model->getAttributeLabel('short_content')]) ?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
		    	<?= $form->field($model, 'link')->textInput(['placeholder' => $model->getAttributeLabel('link')]) ?>
				</div>
		    </div>
			<div class="col-xs-12 col-lg-12 no-padding">
			  <div class="col-xs-12 col-sm-6 col-lg-6">
            <?php if (!empty($model->file)) : ?>
					<?php
					echo $form->field($model, 'file')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => true,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
							'initialPreview' => [
								'<img src="/backend/web/images/slider/' . $model->file . '" class="file-preview-image">',
							],
						]
					])->label('Slider Image');
					?>
				<?php else: ?>
					<?php
					echo $form->field($model, 'file')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => true,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
						]
					])->label('Slider Image');
					?>

				<?php endif; ?>
				  </div>
				</div>
			
	    	<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
				<div class="col-xs-6">
					<?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord  ? 'btn btn-block btn-success' : 'btn btn-block btn-info']) ?>
				</div>
				<div class="col-xs-6">
					<?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
				</div>
	    	</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
