<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\modules\models\SliderSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Slider';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="col-xs-12">
  <div class="col-lg-8 col-sm-8 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> Slider List</h3></div>
  <div class="col-lg-4 col-sm-4 col-xs-12 no-padding" style="padding-top: 20px !important;">
	<div class="col-xs-4 left-padding">

	</div>
	<div class="col-xs-4 left-padding">

	</div>
	<div class="col-xs-4 left-padding">
	 <?php if(Yii::$app->user->can("/slider/create")) { ?>
             <?= Html::a(Yii::t('app', 'ADD'), ['create'], ['class' => 'btn btn-block btn-success']) ?>
	 <?php } ?>
	</div>
  </div>
</div>

<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
      <div class="box-body table-responsive">
	<div class="courses-index">
	<?php $visible = Yii::$app->user->can("/slider/create") ? true : false; ?>
	<?php
	\yii\widgets\Pjax::begin(
	    [
		'id' => 'id',
		'enablePushState'=>false,
		'enableReplaceState' =>false,
	    ]
	); ?>
	    <?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,
		'summary'=>'',
		'columns' => [
		    ['class' => 'yii\grid\SerialColumn'],
            [
				'attribute' => 'file ',
				'format' => 'html',
				'label' => 'Image',
				'value' => function ($model) {
					return Html::img('/seo/backend/web/images/slider/' . $model['file'], ['width' => '250px']);
				}
			],
		    [
                'attribute' => 'heading',
                'value' => function ($model) {
                    return $model->heading;
                },
                'format' => 'html',
            ],
			'link',
			[
			'class' => 'yii\grid\ActionColumn',
			'template' => '{update} {delete}',
			'visible' => $visible,
		    ],
		],
	    ]); ?>
	<?php \yii\widgets\Pjax::end(); ?>
       </div>
     </div>
   </div>
</div>
