<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\modules\models\StateSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'State';
$this->params['breadcrumbs'][] = $this->title;
?>
 <?php if($model->isNewRecord) 
	echo $this->render('create', ['model' => $model]); 
   else
	echo $this->render('update', ['model' => $model]); 	
?>
<div class="col-xs-12">
  <div class="col-lg-12 col-sm-12 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> State List</h3></div>
 </div>

<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
      <div class="box-body table-responsive">
	<div class="courses-index">
	<?php $visible = Yii::$app->user->can("/state/create") ? true : false; ?>
	<?php
	\yii\widgets\Pjax::begin(
	    [
		'id' => 'id',
		'enablePushState'=>false,
		'enableReplaceState' =>false,
	    ]
	); ?>
	    <?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,
		'summary'=>'',
		'columns' => [
		    ['class' => 'yii\grid\SerialColumn'],

		    'state_name',
			[
			'class' => '\pheme\grid\ToggleColumn',
			'contentOptions' => ['class' => 'text-center'],
			'attribute'=>'status',
			'enableAjax' => false,
			'filter'=>['0'=>'Active', '1'=>'Inactive']
		    ],
			[
			'class' => 'yii\grid\ActionColumn',
			'template' => '{update} {delete}',
			'visible' => $visible,
		    ],
  [
			'header' => 'Add Faq',
			'class' => 'yii\grid\ActionColumn',
			'template' => '{view}',
			'buttons' => [
			'view' => function ($url, $model) {
				   return Html::a('<i class="fa fa-plus"></i> Click to Add Faq', ['/state-faq/index', 'id' => $model->id], [
							'title' => Yii::t('app', 'Add Faq'),
							'data-pjax' => "0",
				]);
			 }
			],
			'contentOptions' => ['style' => 'width: 200px;']
		  ],
		],
	    ]); ?>
	<?php \yii\widgets\Pjax::end(); ?>
       </div>
     </div>
   </div>
</div>
