<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;

$this->title = 'Stroy';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="col-xs-12">
  <div class="col-lg-8 col-sm-8 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> Stroy List</h3></div>
  <div class="col-lg-4 col-sm-4 col-xs-12 no-padding" style="padding-top: 20px !important;">
	<div class="col-xs-4 left-padding">

	</div>
	<div class="col-xs-4 left-padding">

	</div>
	<div class="col-xs-4 left-padding">
	 <?php if(Yii::$app->user->can("/story/create")) { ?>
             <?= Html::a(Yii::t('app', 'ADD'), ['create'], ['class' => 'btn btn-block btn-success']) ?>
	 <?php } ?>
	</div>
  </div>
</div>

<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
      <div class="box-body table-responsive">
	<div class="courses-index">
	<?php $visible = Yii::$app->user->can("/story/create") ? true : false; ?>
	<?php
	\yii\widgets\Pjax::begin(
	    [
		'id' => 'id',
		'enablePushState'=>false,
		'enableReplaceState' =>false,
	    ]
	); ?>
	    <?= GridView::widget([
		'dataProvider' => $dataProvider,
		'filterModel' => $searchModel,
		'summary'=>'',
		'columns' => [
		    ['class' => 'yii\grid\SerialColumn'],

		    'heading',
		    [
                'attribute' => 'status',
                'format' => 'html',
                'filter' => ['1' => 'Active', '0' => 'Inactive'],
                'value' => function ($model) {
            if ($model->status === 1) {
                $text = 'Active';
                $class = 'label-success';
            } elseif ($model->status === 0) {
                $text = 'Inactive';
                $class = 'label-danger';
            }

            return '<span class="label ' . $class . '">' . $text . '</span>';
        },
                'contentOptions' => ['style' => 'width: 100px;']
            ],
		    [
			'class' => 'yii\grid\ActionColumn',
			'template' => '{update} {delete}',
			'visible' => $visible,
		    ],
			[
			'header' => 'Add Mutiple Sub-Story',
			'class' => 'yii\grid\ActionColumn',
			'template' => '{view}',
			'buttons' => [
			'view' => function ($url, $model) {				
			   return Html::a('<i class="fa fa-plus"></i> Click to Add Sub-Story', ['/substory', 'id' => $model->id], [
							'title' => Yii::t('app', 'Add Sub-Story'),
							'data-pjax' => "0",
				]);				
			}
			],
			'contentOptions' => ['style' => 'width: 200px;']
		  ],
		],
	    ]); ?>
	<?php \yii\widgets\Pjax::end(); ?>
       </div>
     </div>
   </div>
</div>
