<?php
use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\widgets\FileInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use kartik\editors\Summernote;
use dosamigos\tinymce\TinyMce;
use yii\helpers\Url;
?>
<div class="col-xs-12 col-lg-12">
	<div class="<?php echo $model->isNewRecord ? 'box-success' : 'box-info'; ?> box view-item col-xs-12 col-lg-12">
		<div class="form">
		<?php
			if($this->context->action->id == 'update')
				$action = ['update', 'id'=>$_REQUEST['id']];
			else
				$action = ['create'];
		?>
		    <?php $form = ActiveForm::begin([
					'id' => 'state-form',
					'action' => $action,
					'enableClientValidation' => true,
                'fieldConfig' => [
                    'template' => "{label}{input}{error}",
                ],
		    ]); ?>


		    <div class="col-xs-12 col-lg-12 no-padding">
			    <div class="col-xs-12 col-sm-6 col-lg-6">
		    	  <?= $form->field($model, 'name')->textInput(['placeholder' => $model->getAttributeLabel('name')]) ?>
				</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
		    	  <?= $form->field($model, 'slug')->textInput(['placeholder' => $model->getAttributeLabel('slug')]) ?>
				</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
		    	  <?= $form->field($model, 'heading')->textInput(['placeholder' => $model->getAttributeLabel('heading')]) ?>
				</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
					<?= $form->field($model, 'introduction')->widget(TinyMce::class, [
						'options' => ['rows' => 10],
						'clientOptions' => [
							'license_key' => 'gpl',
							'promotion' => false,
							'branding' => false,
							'menubar' => false,
							'toolbar_mode' => 'sliding',
							'height' => 400,
							'plugins' => 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen insertdatetime media table help wordcount',
                            'toolbar' => 'undo redo blocks bold italic underline strikethrough forecolor backcolor alignleft aligncenter alignright alignjustify bullist numlist blockquote outdent indent link image media table charmap preview searchreplace visualblocks code fullscreen help',
							'automatic_uploads' => true,
							'images_upload_url' => \yii\helpers\Url::to(['site/upload-image']),
							'file_picker_types' => 'image',
						]
					]); ?>
				</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
		    	  <?php if (!empty($model->image)) : ?>
					<?php
					echo $form->field($model, 'image')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => true,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
							'initialPreview' => [
								'<img src="/demo/backend/web/images/tag/small/' . $model->image . '" class="file-preview-image">',
							],
						]
					])->label('Page Image (Size : 1200px * 400px)');
					?>
				<?php else: ?>
					<?php
					echo $form->field($model, 'image')->widget(FileInput::classname(), [
						'pluginOptions' => [
							'showPreview' => true,
							'showCaption' => true,
							'showRemove' => false,
							'showUpload' => false,
						]
					])->label('Page Image (Size : 500px * 300px)');
					?>

				<?php endif; ?>
				</div>
		    </div>
			
			<div class="col-xs-12 col-lg-12 no-padding">
		    	<div class="col-xs-12 col-sm-6 col-lg-6">
				  <?= $form->field($model, 'meta_title')->textInput(['placeholder' => $model->getAttributeLabel('meta_title')]) ?>
		    	</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?= $form->field($model, 'meta_keyword')->textArea(['placeholder' => $model->getAttributeLabel('meta_keyword')]) ?>
	    		</div>
				<div class="col-xs-12 col-sm-6 col-lg-6">
	    			<?= $form->field($model, 'meta_description')->textArea(['placeholder' => $model->getAttributeLabel('meta_description')]) ?>
	    		</div>
           </div>

			<div class="form-group col-xs-12 col-sm-6 col-lg-4 no-padding">
				<div class="col-xs-6">
					<?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord  ? 'btn btn-block btn-success' : 'btn btn-block btn-info']) ?>
				</div>
				<div class="col-xs-6">
					<?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn-default btn-block']) ?>
				</div>
	    	</div>

	    	<?php ActiveForm::end(); ?>
		</div>
	</div>
</div>
