<?php
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

use \yii\web\Request;
$baseUrl = str_replace('/frontend/web', '', (new Request)->getBaseUrl());

return [
    'id' => 'app-frontend',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
	'timeZone' => 'Asia/Kolkata',
    'controllerNamespace' => 'frontend\controllers',
	'modules' => [
    'user' => [
        // following line will restrict access to admin controller from frontend application
        'as frontend' => 'dektrium\user\filters\FrontendFilter',
      ],
    ],
    'components' => [
	     'urlManagerFrontend' => [
			'class' => 'yii\web\urlManager',
			'baseUrl' => '/ourindia/frontend/web/', //Access frontend web url
		],
		'urlManagerBackend' => [
			'class' => 'yii\web\urlManager',
			'baseUrl' => '/ourindia/backend/web/', //Access frontend web url
		],
		 'assetManager' => [
        'forceCopy' => YII_ENV_DEV ? true : false,
        //'appendTimestamp' => true,
        ],
        'request' => [
            'baseUrl' => $baseUrl,
            'csrfParam' => '_csrf-frontend',
        ],
        // 'user' => [
            // 'identityClass' => 'common\models\User',
            // 'enableAutoLogin' => true,
            // 'identityCookie' => ['name' => '_identity-frontend', 'httpOnly' => true],
        // ],
            'user' => [
				'identityCookie' => [
					'name'     => '_frontendIdentity',
					'path'     => '/',
					'httpOnly' => true,
				],
				'loginUrl' => ['security/login'], 
			],
			'session' => [
				'name' => 'FRONTENDSESSID',
				'cookieParams' => [
					'httpOnly' => true,
					'path'     => '/',
				],
			], 
		'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            'viewPath' => '@common/mail',
            'useFileTransport' => false, //set this property to false to send mails to real email addresses
            //comment the following array to send mail using php's mail function
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'smtp.ipage.com',
                'username' => 'info@exploreourindia.com',
                'password' => 'Yaminnii_2212',
                'port' => '587',
                'encryption' => 'tls',
                'StreamOptions' => ['ssl' => ['allow_self_signed' => true, 'verify_peer' => false]]
            ],
        // send all mails to a file by default. You have to set
        // 'useFileTransport' to false and configure a transport
        // for the mailer to send real emails.
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
		'urlManager' => [
			'class' => 'yii\web\UrlManager',
		   'baseUrl' => $baseUrl,
		    'enablePrettyUrl' => true,
            'showScriptName' => false,
            'enableStrictParsing' => true,
           'normalizer' => [
				'class' => yii\web\UrlNormalizer::class,
			],
			'rules' => [
					'/' => 'site/index', 
					'contact-us/state-delhi' => 'contact-us/state-delhi',
					'index-test' => 'site/index-test',				 
					'privacy-policy' => 'site/privacy', 
					'about-us' => 'site/about', 
					'/stories/sharestories' => '/site/sharestories',	
					'web-stories' => 'story/index', 
					'web-stories/<slug:[A-Za-z0-9 -_.]+>' => 'story/view',
					'category/<slug:[A-Za-z0-9 -_.]+>' => 'category/view',
					'state' => 'state/index',
                    'famous-places' => 'famous-places/index',
					'famous-places/<slug:[A-Za-z0-9 -_.]+>' => 'famous-places/view',
					'contact-us' => 'contact-us/index',
                    'news-update' => 'news/index',                                        
					'news-update/<slug:[A-Za-z0-9 -_.]+>' => 'news/view',
					'blog' => 'blog/index',                                        
					'blog/<slug:[A-Za-z0-9 -_.]+>' => 'blog/view',
					'cricket' => 'cricket/index',   
                    '/search-results' => '/site/search',					
					'cricket/<slug:[A-Za-z0-9 -_.]+>' => 'cricket/view',
					'movie' => 'movie/index',                                        
					'movie/<slug:[A-Za-z0-9 -_.]+>' => 'movie/view',
					'state/<slug:[A-Za-z0-9 -_.]+>/<slugtour:[A-Za-z0-9 -_.]+>' => 'state/view-tourism',
					'state/<slug:[A-Za-z0-9 -_.]+>' => 'state/view',					
					'city/<slug:[A-Za-z0-9 -_.]+>' => 'city/view',
					'tag/<slug:[A-Za-z0-9 -_.]+>' => 'tag/view',
                    'state-tag' => 'post/statetag',
					'<state:[A-Za-z0-9 -_.]+>/<slug:[A-Za-z0-9 -_.]+>' => 'post/statecategory',
					'sitemap.xml' => 'sitemap/index', 
					'<slug:[A-Za-z0-9 -_.]+>' => 'post/view',
					'/user/logout' => '/user/security/logout',
					'<controller:\w+>/<action:\w+>/' => '<controller>/<action>',
			],
		],
		'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
     ],
	 'as access' => [
        'class' => 'mdm\admin\components\AccessControl',
        'allowActions' => [
				'site/*',
				'security/*',
				'sitemap/*',
				'post/*',
				'category/*',
				'state/*',
				'city/*',
'story/*',
				'blog/*',
'news/*',
				'cricket/*',
				'movie/*',
				'tag/*',
                                'contact-us/*',
'famous-places/*',
        ],
    ],
    'params' => $params,
];
