<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\Blog;
use backend\models\BlogCategory;
use frontend\models\Comments;
use yii\helpers\Url;
use backend\models\State;
use frontend\models\ShareYourTravelStory;

class BlogController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'view'],
                        'allow' => true,
                        'roles' => ['?', '@']
                    ],
                ]
            ],
        ];
    }
	
	public function actionIndex() {
     	$caQuery = Blog::find()->where(['status' => 1]);
		$catDataProvider = new ActiveDataProvider([

            'query' => $caQuery,
            'sort' => [
                'defaultOrder' => [
                    'id' => SORT_DESC,
                ]
            ],
            'pagination' => [
                'pageSize' => 10,
        ]]);
		$popularBlog = Blog::find()->where(['status' => 1])->orderBy(['blog_view' => SORT_DESC])->limit(10)->all();
		$travelstory = ShareYourTravelStory::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(6)->all();
		return $this->render('index', [
					'catDataProvider' => $catDataProvider,
					'popularBlog' => $popularBlog,
					'travelstory' => $travelstory,
		]);
    }
	
	public function actionView($slug) {
	    $this->layout = 'blog';
		$modelcomment = new Comments();
		$postQueryy = Blog::find()->where(['slug' => $slug, 'status' => 1])->one();
		if(isset($postQueryy)) {
		$totalview = ($postQueryy->blog_view + 1);
			$connection = Yii::$app->db;
			$command = $connection->createCommand()->update('blog', ['blog_view' => $totalview], ['status' => 1, 'id' => $postQueryy->id])->execute();
			$connection->close();
		$postQuery = Blog::find()->where(['slug' => $slug, 'status' => 1])->one();
		 $relatedBlog = Blog::find()->where(['cat_id' => $postQuery->cat_id, 'status' => 1])->AndWhere(['!=', 'id', $postQuery->id])->orderBy(['id' => SORT_DESC])->limit(15)->all();
		 $recentBlog = Blog::find()->where(['status' => 1])->AndWhere(['!=', 'id', $postQuery->id])->orderBy(['id' => SORT_DESC])->limit(5)->all();
		 $popularBlog = Blog::find()->where(['status' => 1])->orderBy(['blog_view' => SORT_DESC])->limit(10)->all();
		 $count_all = Comments::find()->where(['status' => 1])->andwhere(['blog_id' => $postQuery->id])->all();
		 $comments_all = Comments::find()->where(['status' => 1])->andwhere(['parent_id' => 0])->andwhere(['blog_id' => $postQuery->id])->orderBy(['id' => SORT_DESC])->all();
		 if ($modelcomment->load(Yii::$app->request->post())) {
	             Yii::$app->getSession()->destroy();
			if (Yii::$app->request->isAjax) {
				Yii::$app->response->format = Response::FORMAT_JSON;
				return ActiveForm::validate($modelcomment);
			}
			
			$modelcomment->blog_id = $postQuery->id;
		  if($modelcomment->save(false)) {
            \Yii::$app->getSession()->setFlash('copmssg', 'Your Comment will only be visible after moderation!');
			return $this->redirect(Yii::$app->request->referrer);
		  } else {
             \Yii::$app->getSession()->setFlash('copmssgerror', 'Unable to add your Comment.');
			 return $this->redirect(Yii::$app->request->referrer); 
		  }
		} else {
		 return $this->render('view', [
                    'postQuery' => $postQuery,
					'relatedBlog' => $relatedBlog,
					'recentBlog' => $recentBlog,
					'popularBlog' => $popularBlog,
					'modelcomment' => $modelcomment,
					'count_all' => $count_all,
					'commentalls' => $comments_all,
             ]);
		}	
        } else {
			throw new NotFoundHttpException('The requested page does not exist.');
		 }		
	}		 
}

