<?php

namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use frontend\models\ContactUs;
use frontend\models\ContactUsSearch;
use yii\web\Response;
use backend\models\EmailTemplate;
use yii\helpers\Json;
use \yii\db\Expression;


class ContactUsController extends Controller {

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'statelist', 'state-delhi'],
                        'allow' => true,
                        'roles' => ['?', '@']
                    ],
                ]
            ],
        ];
    }
	
	public function actionStateDelhi() {     	
		 return $this->render('state-delhi');
    }

    /**
     * Lists all SubscribeSubscribers models.
     * @return mixed
     */
    public function actionIndex() {
		$model = new ContactUs();
                if (Yii::$app->request->isAjax) {
		 if($model->load(Yii::$app->request->post())) {
				\Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
				return ActiveForm::validate($model);
			}
		}
           if ($model->load(Yii::$app->request->post())) {
             if($model->save(false)) {
			
				/*$dbTemplateModel = EmailTemplate::find()->where(['id' => 1, 'status' => 1])->one();
				$message = $dbTemplateModel->template;
				$message = str_replace("###Name###", $model->name, $message); //Replace ##MESSAGE## by user send message
				$message = str_replace("###siteurl###", 'https://www.exploreourindia.com/', $message);

				 Yii::$app->mailer->compose()
					 ->setFrom(['no-reply@exploreourindia.com' => 'exploreourindia.com'])
					 ->setTo($model->email)
					 ->setSubject($dbTemplateModel->email_subject)
					 ->setTextBody('Plain text content')
					 ->setHtmlBody($message)
					 ->send();
					
				$dbTemplateModell = EmailTemplate::find()->where(['id' => 2, 'status' => 1])->one();
				$messagee = $dbTemplateModell->template;
				$messagee = str_replace("###Name###", $model->name, $messagee); 
				$messagee = str_replace("###Phone###", $model->contact_no, $messagee);
				$messagee = str_replace("###emailid###", $model->email, $messagee);
				$messagee = str_replace("###comment###", $model->message, $messagee);
				$messagee = str_replace("###siteurl###", 'https://www.exploreourindia.com/', $messagee);

				 Yii::$app->mailer->compose()
					 ->setFrom(['no-reply@exploreourindia.com' => 'exploreourindia.com'])
					 ->setTo('exploreourindia21@gmail.com')
					 ->setSubject($dbTemplateModell->email_subject)
					 ->setTextBody('Plain text content')
					 ->setHtmlBody($messagee)
					 ->send();*/
					
				\Yii::$app->getSession()->setFlash('copmssg', 'Submitted Successfully ! Team Will Contact Soon!');
				return $this->redirect(Yii::$app->request->referrer);
			  }	else {
				 \Yii::$app->getSession()->setFlash('copmsgerror', 'Sorry, Something went wrong.');
				 return $this->redirect(Yii::$app->request->referrer); 
			  }
           } else {
		return $this->render('index', [
                'model' => $model,
            ]);
	 }
    }

public function actionStatelist($id){
        $rows = backend\models\City::find()->where(['state_id' => $id,'status' => 1])->all();	 
		echo "<option value=''>".Yii::t('app', '--- Select City ---')."</option>";	 
		if(count($rows)>0){
		    foreach($rows as $row){
		        echo "<option value='$row->id'>$row->city_name</option>";
		    }
		} else {
		    echo "";
		}
     }
    
}
