<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\Post;
use backend\models\State;
use backend\models\Category;
use backend\models\Blog;
use backend\models\BlogCategory;
use backend\models\Tag;
use frontend\models\ShareYourTravelStory;

class PostController extends Controller {

    /**
     * @inheritdoc
     */
    public $enableCsrfValidation = false; 
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'view', 'statecategory', 'statetag'],
                        'allow' => true,
                        'roles' => ['?', '@']
                    ],
                ]
            ],
        ];
    }

    public function actionIndex() {
     	 $postQuery = Post::find()->where(['status' => 1])->all();
		 return $this->render('index', [
                    'postQuery' => $postQuery,
             ]);
    }
	
	public function actionView($slug) {
		 $this->layout = 'postview';
         $postQuery = Post::find()->where(['slug' => $slug, 'status' => 1])->one();
		 if(isset($postQuery)) {
		 $orderid = array();
		 
		 $postQueryAll = Post::find()->where(['status' => 1])->Andwhere(['state_id' => $postQuery->state_id])->select('category_id')->distinct()->all();
			foreach($postQueryAll as $modelqntyy) {
				$orderid[] = $modelqntyy->category_id;
			}
          $arrayorderid = array_unique($orderid);
         $recentBlog = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(5)->all();
		 $modelstate = State::find()->where(['status' => 1])->orderBy(['id' => SORT_ASC])->all();
		 $travelstory = ShareYourTravelStory::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(6)->all();
		 return $this->render('view', [
                    'postQuery' => $postQuery,
					'arrayorderid' => $arrayorderid,
                                        'recentBlog' => $recentBlog,
										'modelstate' => $modelstate,
										'travelstory' => $travelstory,
             ]);
		} else {
			throw new NotFoundHttpException('The requested page does not exist.');
		 }	 
	}

    public function actionStatecategory($state, $slug) {
		 $stateQuery = State::find()->where(['slug' => $state, 'status' => 1])->one();
		 $categoryQuery = Category::find()->where(['slug' => $slug, 'status' => 1])->one();
		 if(isset($stateQuery) && isset($categoryQuery)) {
		 $postQueryAll = Post::find()->where(['status' => 1])->Andwhere(['state_id' => $stateQuery->id])->Andwhere(['category_id' => $categoryQuery->id]);
		 $postDataProvider = new ActiveDataProvider([

            'query' => $postQueryAll,
            'sort' => [
                'defaultOrder' => [
                    'id' => SORT_DESC,
                ]
            ],
            'pagination' => [
                'pageSize' => 21,
        ]]);
		 return $this->render('statecategory', [
                    'stateQuery' => $stateQuery,
					'categoryQuery' => $categoryQuery,
					'postDataProvider' => $postDataProvider,
             ]);
		} else {
			throw new NotFoundHttpException('The requested page does not exist.');
		 }	 
	}

      public function actionStatetag() {
		 $data=Yii::$app->request->post();
            //print_r(json_encode($data));
			//exit;
		$tagiiid = array();	
		if(!empty($data)) {	
		 if($data['stateid'] != '') {
			 $stateiiid = $data['stateid'];
		 } 
		 
		 if($data['tagid'] != '') {
			 $tagiiid = $data['tagid'];
		 }
		} else {
			 $stateiiid = 10;
			 $tagiiid = ["22","2"];
		 }
		 $stateQuery = State::find()->where(['id' => $stateiiid, 'status' => 1])->one();
		 $recentBlog = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(5)->all();
		 $orderid = array();
         $postQueryAll = Post::find()->where(['status' => 1])->Andwhere(['state_id' => $stateQuery->id])->select('category_id')->distinct()->all();
			foreach($postQueryAll as $modelqntyy) {
				$orderid[] = $modelqntyy->category_id;
			}
          $arrayorderid = array_unique($orderid);
		 return $this->render('statetag', [
                    'stateQuery' => $stateQuery,
					'tagQuery' => $tagiiid,
					'stateidd' => $stateiiid,
					'recentBlog' => $recentBlog,
					'arrayorderid' => $arrayorderid,
             ]);
	}
}
