<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use dektrium\user\models\User;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use backend\models\Tag;
use backend\models\Post;
use yii\web\Response;
use frontend\models\ContactUs;
use frontend\models\ContactUsSearch;
use yii\helpers\Json;
use yii\widgets\ActiveForm;
use \yii\db\Expression;
use backend\models\Blog;
use backend\models\BlogCategory;
use backend\models\TopPlaces;
use backend\models\State;
use backend\models\Movie;
use frontend\models\ShareYourTravelStory;
use yii\web\UploadedFile;
use yii\imagine\Image;
use Imagine\Gd;
use Imagine\Image\Box;
use Imagine\Image\BoxInterface;
use Imagine\Image\ManipulatorInterface;
/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public $enableCsrfValidation = false;
    
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'privacy', 'about', 'error', 'sharestories', 'search', 'index-test'],
                        'allow' => true,
                        'roles' => ['?', '@']
                    ],
                ]
            ],
        ];
    }

    public function actions() {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'auth' => [
                'class' => 'yii\authclient\AuthAction',
                'successCallback' => [$this, 'authenticate'],
            ],
			'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }
    /**
     * Displays homepage.
     *
     * @return mixed
     */
	 
	/* remove after.... andwhere(['id' => 11])->*/  
   public function actionSharestories() {
		$model = new ShareYourTravelStory();
         if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
          Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

			if ($_FILES['ShareYourTravelStory']['name']['img'] != '') {
                $uploadFile = UploadedFile::getInstance($model, 'img');

                $random_digit = rand(0000, 9999);
                $fileName = $random_digit . "_{$uploadFile}";
                $model->img = $fileName;
                $uploadFile->saveAs('images/tarvel-story-img/' . $fileName);
   
            }
         if($model->save(false)) {            
            Yii::$app->session->setFlash('copmssg', "Submitted Successfully ! Team Will Contact Soon!");
            return $this->redirect(Yii::$app->request->referrer);
		  }	else {
			 $json = json_encode(["error" => true,"message" => 'Sorry, Something went wrong.']);
            		        return $json;
		  }
       } else {
		return $this->renderAjax('shareyourstories', [
				'model' => $model
			]);
       }
    }
	
   public function actionIndexTest()
    {
		$PostQuery = Post::find()->where(['status' => 1])->orderBy('id')->one();	
		$TagoneQuery = Tag::find()->where(['status' => 1])->where(['between', 'id', 1, 12])->andwhere(['!=', 'id', 2])->orderBy(new Expression('rand()'))->one();
		$PosthaerQuery = Post::find()->where(['status' => 1])->andwhere(['category_id' => 1])->orderBy('id')->limit(4)->all();			   
		$recentBlog = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(10)->all();
		$modeltag = Tag::find()->where(['slug' => 'popular', 'status' => 1])->one();
		$popularpost = Post::find()->where(['status' => 1])->andWhere('FIND_IN_SET('.$modeltag->id.', tag_id)')->orderBy(['id' => SORT_DESC])->limit(10)->all();
		$popularBlog = Blog::find()->where(['status' => 1])->orderBy(['blog_view' => SORT_DESC])->limit(9)->all();
		$Posthaerrel = Post::find()->where(['status' => 1])->andwhere(['category_id' => 2])->orderBy('id')->limit(8)->all();	
		$topplacesQuery = TopPlaces::find()->where(['status' => 1])->andwhere(['id' => 1])->one();
		$PostrelQuery = Post::find()->where(['status' => 1])->andwhere(['category_id' => 2])->orderBy('id')->limit(8)->all();	
		$blogQuery = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->one();
		$modelstate = State::find()->where(['status' => 1])->orderBy(['id' => SORT_ASC])->all();
		$movie = Movie::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(6)->all();
		$travelstory = ShareYourTravelStory::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(6)->all();
		$searchModel = new Post;
        return $this->render('index-test',[
			'TagoneQuery' => $TagoneQuery,
			'PostQuery' => $PostQuery,
			'PosthaerQuery' => $PosthaerQuery,
			'recentBlog' => $recentBlog,
			'popularpost' => $popularpost,
			'popularBlog' => $popularBlog,
			'posthaerrel' => $Posthaerrel,
			'topplacesQuery' => $topplacesQuery,
			'PostrelQuery' => $PostrelQuery,
			'blogQuery' => $blogQuery,
			'modelstate' =>$modelstate,
			'movie' =>$movie,
			'searchModel' => $searchModel,
			'travelstory' => $travelstory,
	   ]);
    }    
    
   public function actionPrivacy() {
	  return $this->render('privacy');   
   }
	 
	  public function actionAbout() {
	  return $this->render('about');   
   }
   
   public function actionSearch() {
        return $this->render('search');
    }
	   
   public function actionIndex()
    {
		$this->layout = 'mainshome';
		$PostQuery = Post::find()->where(['status' => 1])->orderBy('id')->one();	
		$TagoneQuery = Tag::find()->where(['status' => 1])->where(['between', 'id', 1, 12])->andwhere(['!=', 'id', 2])->orderBy(new Expression('rand()'))->one();
		$PosthaerQuery = Post::find()->where(['status' => 1])->andwhere(['category_id' => 1])->orderBy('id')->limit(4)->all();			   
		$recentBlog = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(10)->all();
		$modeltag = Tag::find()->where(['slug' => 'popular', 'status' => 1])->one();
		$popularpost = Post::find()->where(['status' => 1])->andWhere('FIND_IN_SET('.$modeltag->id.', tag_id)')->orderBy(['id' => SORT_DESC])->limit(10)->all();
		$popularBlog = Blog::find()->where(['status' => 1])->orderBy(['blog_view' => SORT_DESC])->limit(9)->all();
		$Posthaerrel = Post::find()->where(['status' => 1])->andwhere(['category_id' => 2])->orderBy('id')->limit(8)->all();	
		$topplacesQuery = TopPlaces::find()->where(['status' => 1])->andwhere(['id' => 1])->one();
		$PostrelQuery = Post::find()->where(['status' => 1])->andwhere(['category_id' => 2])->orderBy('id')->limit(8)->all();	
		$blogQuery = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->one();
		$modelstate = State::find()->where(['status' => 1])->orderBy(['id' => SORT_ASC])->all();
		$movie = Movie::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(6)->all();
		$travelstory = ShareYourTravelStory::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(6)->all();
		$searchModel = new Post;
       return $this->render('index',[
			'TagoneQuery' => $TagoneQuery,
			'PostQuery' => $PostQuery,
			'PosthaerQuery' => $PosthaerQuery,
			'recentBlog' => $recentBlog,
			'popularpost' => $popularpost,
			'popularBlog' => $popularBlog,
			'posthaerrel' => $Posthaerrel,
			'topplacesQuery' => $topplacesQuery,
			'PostrelQuery' => $PostrelQuery,
			'blogQuery' => $blogQuery,
			'modelstate' =>$modelstate,
			'movie' =>$movie,
			'searchModel' => $searchModel,
			'travelstory' => $travelstory,
	   ]);
    }
    
     public function actionError() { 
         $exception = Yii::$app->errorHandler->exception; 
         if ($exception !== null) { 
             if ($exception->statusCode == 404) 
              return $this->render('error404', ['exception' => $exception]); 
             else 
             return $this->render('error', ['exception' => $exception]); 
        } 
     }
 }
