<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\db\Query;
use backend\models\Post;
use backend\models\Blog;
use backend\models\Category;
use backend\models\Tag;

class SitemapController extends Controller
{

    public function actionIndex()
    {
        Yii::$app->response->format = \yii\web\Response::FORMAT_RAW;
        Yii::$app->response->headers->add('Content-Type', 'text/xml');
        $postlist = Post::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->all();
		$bloglist = Blog::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->all();
		$categorytlist = Category::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->all();
		$taglist = Tag::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->all();
		return $this->renderPartial('index', [
		      'postlist' => $postlist,
			  'bloglist' => $bloglist,
			  'categorytlist' => $categorytlist,
			  'taglist' => $taglist,
		]);

    }
    
   
}
?>