<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidArgumentException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\State;
use backend\models\StateTourism;
use backend\models\Post;
use frontend\models\ShareYourTravelStory;

class StateController extends Controller {

    /**
     * @inheritdoc
     */
    public $enableCsrfValidation = false; 
    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['index', 'view', 'view-tourism'],
                        'allow' => true,
                        'roles' => ['?', '@']
                    ],
                ]
            ],
        ];
    }  
	
	public function actionIndex() {
		$data=Yii::$app->request->post();
        if(isset($data['stateid'])) {
		  return $this->render('statewise', [
				'stateData' => $data['stateid'],
			]);
		} else {
		  $caQuery = State::find()->where(['status' => 1]);
          $stateDataProvider = new ActiveDataProvider([
            'query' => $caQuery,
            'sort' => [
                'defaultOrder' => [
                    'id' => SORT_DESC,
                ]
            ],
            'pagination' => [
                'pageSize' => 21,
			]]);
			
			return $this->render('index', [
						'stateDataProvider' => $stateDataProvider,
			]);		  
		}
    }
	
	public function actionView($slug = NULL) {
		$this->layout = 'stateview';
        $model = State::find()->where(['slug' => $slug, 'status' => 1])->one();
		$modelstate = State::find()->where(['status' => 1])->Andwhere(['!=', 'id', $model->id])->all();
	    $modeltour = StateTourism::find()->where(['state_id' => $model->id, 'status' => 1])->one();
		$travelstory = ShareYourTravelStory::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->limit(6)->all();
		return $this->render('view', [
					'model' => $model,
					'modeltour' => $modeltour,
					'modelstate' => $modelstate,
					'travelstory' => $travelstory,
		]);
    }
	
	public function actionViewTourism($slug = NULL, $slugtour = NULL) {
		$this->layout = 'stateview';
        $model = State::find()->where(['slug' => $slug, 'status' => 1])->one();
	    $modeltour = StateTourism::find()->where(['slug' => $slugtour, 'status' => 1])->one();
		return $this->render('viewtour', [
					'model' => $model,
		]);
    }
}
