<?php
namespace frontend\models;

use Yii;
use yii\helpers\Html;
use yii\base\Model;
use \yii\db\Expression;
use dektrium\user\models\User;
use backend\models\Blog;
use backend\models\Category;

class Comments extends \yii\db\ActiveRecord {
    /**
     * @inheritdoc
     */
   public $reCaptcha; 
   public static function tableName()
    {
        return 'comments';
    }

    /**
     * @inheritdoc
     */

    public function rules() {
        return [
            [['id', 'blog_id', 'name', 'email','comment', 'create_on', 'create_by', 'status'], 'required'],
            [['name', 'email', 'create_on', 'update_on'], 'safe'],
            [['parent_id', 'update_by', 'status'], 'integer'],
            ['email', 'email'],
            [['name'], 'string', 'max' => 100],
			[['reCaptcha'], \himiklab\yii2\recaptcha\ReCaptchaValidator2::className(), 'secret' => '6Le9yTAmAAAAAAgw46TeUh1uKOyYxsZiXuQy58Ir', 'uncheckedMessage' => 'Please confirm that you are not a robot.'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
             'name' => 'Name',
            'email' => 'Email',
			'blog_id' => 'Blog Heading',
			'comment' => 'Comment',
			'parent_id' => 'Parent Heading',
			'create_on' => 'Create On',
            'update_on' => 'Update On',
            'update_by' => 'Update By',
            'status' => 'Status',
        ];
    }
	
	public function getUspackage()
    {
        return $this->hasOne(Blog::className(), ['id' => 'blog_id']);
    }
    
    public function getUsmember()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
	
	public function getCommenttt()
    {
        return $this->hasOne(Comments::className(), ['id' => 'parent_id']);
    }
	
	public function beforeSave($insert) {

        if ($this->isNewRecord) {
			 $this->create_on = new Expression('NOW()');
            $this->create_by = 1;
        } else {
            $this->update_on = new Expression('NOW()');
            $this->update_by = 1;
        }
        if (isset($this->create_on) && $this->create_on != '') {
            $this->create_on = new Expression('NOW()');
        }
        return parent::beforeSave($insert);
    }
    function get_reply_comment($blog_id = 0, $parent_id = 0, $marginleft = 0)
	{
	 $blogall = Comments::find()->where(['parent_id' => $parent_id, 'status' => 1])->andwhere(['blog_id' => $blog_id])->all();
	 $output = '';
	 if($parent_id == 0)
	 {
	  $marginleft = 0;
	 }
	 else
	 {
	  $marginleft = $marginleft + 10;
	 }
	 if(count($blogall) > 0)
	 {
	  foreach($blogall as $row)
	  {
	   $output .= '<li style="margin-left:'.$marginleft.'px"><div class="comment">
						<div class="img-thumbnail img-thumbnail-no-borders d-none d-sm-block">
							<img class="avatar" alt="'.ucwords($row->name).'" src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/blog/user-blog.jpg">
						</div>
						<div class="comment-block">
							<div class="comment-arrow"></div>
							<span class="comment-by">
								<i class="fa fa-caret-left" aria-hidden="true"></i> In reply to '.ucwords($row->commenttt->name).'<br>
								<strong>'.ucwords($row->name).'</strong>
								<span class="float-right">
									<span> <a href="#" class="repplly" id="'.$row->id.'"><i class="fas fa-reply"></i> Reply</a></span>
								</span>
							</span>
							<p>'.$row->comment.'</p>
							<span class="date float-right">'.date('M d, Y', strtotime($row->create_on)).'</span>
						</div>
					</div></li>';
	   $output .= $this->get_reply_comment($row->blog_id, $row->id, $marginleft);
	  }
	 }
	 return $output;
	}

}
