<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\models\Comments;

class CommentsSearch extends Comments
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'blog_id', 'parent_id', 'update_by', 'status'], 'integer'],
            [['comment', 'name', 'email', 'create_on', 'update_on'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
	public function search($params)
    {
        $query = Comments::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query, 'sort'=> ['defaultOrder' => ['id'=>SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
			'blog_id' => $this->blog_id,
			'create_on' => $this->create_on,
            'update_on' => $this->update_on,
            'update_by' => $this->update_by,
            'status' => $this->status,
        ]);

         $query->andFilterWhere(['like', 'name', $this->name])
               ->andFilterWhere(['like', 'email', $this->email])
               ->andFilterWhere(['like', 'comment', $this->comment]);

    	return $dataProvider;
    } 
    
}
