<?php
use yii\helpers\Html;
use yii\widgets\ListView;
use yii\helpers\Url;
use yii\db\Query;
/* @var $this yii\web\View */
$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$this->title = $stateQuery->state_name.' - '.$categoryQuery->name;
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => 'State',
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => 'State',
]);
$ogimage = 'https://www.exploreourindia.com/frontend/web/images/logo.png';
$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => 'State'], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => $ogimage], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => 'State'], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => $ogimage], 'twitter:image');
?>
<div role="main" class="main">
    <section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
      <div class="container">
        <div class="row">
          <div class="col-md-12 align-self-left order-1">
            <ul class="breadcrumb d-block text-left">
              <li><?=Html::a("Home", ['/site/index'])?></li>
			  <li><?=Html::a($stateQuery->state_name, ['/state/view', 'slug' => $stateQuery->slug])?></li>
			  <li><?=Html::a($categoryQuery->name, ['/category/view', 'slug' => $categoryQuery->slug])?></li>
            </ul>
          </div>
        </div>
      </div>
    </section>
<div class="container">
      <div class="row">
        <div class="col-lg-9 order-lg-1">
		  
		  <?=
                ListView::widget([
                    'dataProvider' => $postDataProvider,
                    'itemView' => '_category',
                    'layout' => '{items}',
                    'emptyText' => "<div class='panel add_box'>
                                    <table class='table'>
                                        <div class='col-sm-12 text-center'>
                                            <img src='".Yii::$app->urlManagerFrontend->baseUrl.'/images/nodata.jpg'."' alt='Main Title Here'>
                                            <p2><br/><b>Available Soon !</b></p2>
                                        </div>            
                                    </table>
                                </div>",
                ])
                ?>
            
				<div class="blog-posts">
							<div class="pagination float-right">
									<?=
									ListView::widget([

										'dataProvider' => $postDataProvider,
										'layout' => '{pager}',
									])
									?> 
							</div>
				</div> 
		</div>
		<?php
			 $encFile = Yii::getAlias('@common') . '/widgets/sidebar.php';
			 include($encFile);
			?> 
	</div>
</div>	
