<?php

use yii\helpers\Html;
use common\widgets\Alert;
use kartik\widgets\ActiveForm;
use backend\models\Post;
use backend\models\Tag;
use backend\models\Blog;
use backend\models\State;
use backend\models\City;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\widgets\TypeaheadBasic;

$this->registerCssFile('https://www.exploreourindia.com/frontend/web/css/homecss.css', ['position' => \yii\web\View::POS_HEAD]);
$this->registerCssFile('https://www.exploreourindia.com/frontend/web/css/component.css', ['position' => \yii\web\View::POS_HEAD]);
$this->registerJsFile('https://www.exploreourindia.com/frontend/web/js/jquery.flipshow.min.js', ['position' => \yii\web\View::POS_END]);

$js = <<<JS
   $(document).on('click', '.buttonmodalquery',function(){ 
		$('#popup').modal('show')
		 .find('#askquery')
		 .load($(this).attr('value'));
	});
JS;
$this->registerJs($js);

if (Yii::$app->session->hasFlash('copmssg')) { 
$js = <<<JS
 $("#myModal").show();
$("#myModal").addClass("show");
$("#myModal").css({ "display": "block", "background-color": "rgba(0,0,0,0.4)" });
JS;
$this->registerJs($js);
} 

$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

$this->title = "Best Places to Visit in India | Explore Our India";
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => "Discover the best places to visit in Incredible India with Explore Our India. Experience rich culture, vibrant festivals, food, and travel destinations.",
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => "India travel guide, best places to visit in India, Indian festivals, Indian culture, tourism in India, Indian heritage, famous Indian destinations, spiritual tourism, adventure travel India, travel blog India, historical places in India, Explore Our India, Heritage, Religious, Adventure, Wildlife, Ecotourism, Beach, WaterFalls, Mountains, Blog, Temple, Mandir, Paragliding,	Wildlife Safari, Rafting, Scuba Diving, Zip-Lining, Top tourist Places in India, Tourist Places in India, Heritage Place, Religious Place, Adventure Place, Andhra Pradesh Tourism,  Arunachal Pradesh Tourism,  Assam Tourism, Bihar Tourism,  Chhattisgarh Tourism,  Goa Tourism, Gujarat Tourism,  Haryana Tourism, Himachal Pradesh Tourism, Himachal Tourism,  Jharkhand Tourism, Karnataka Tourism, Kerala Tourism, Madhya Pradesh Tourism,  Maharashtra Tourism,  Manipur Tourism,  Meghalaya Tourism,  Mizoram Tourism,  Nagaland Tourism,  Odisha Tourism,  Punjab Tourism,  Rajasthan Tourism, Sikkim Tourism,  Tamil Nadu Tourism,  Telangana Tourism,  Tripura Tourism,  Uttar Pradesh Tourism,  Uttarakhand Tourism,  West Bengal Tourism,  Chandigarh Tourism,  Dadra & Nagar Haveli and Daman & Diu Tourism,  Delhi Tourism,  Jammu and Kashmir Tourism,  Lakshadweep Tourism,  Puducherry Tourism,  Ladakh Tourism, tourist places in delhi,  tourist places around delhi ncr, tourist places around 500 kms,  tourist places at nainital,  tourist places Allahabad,  tourist places around delhi,  tourist places agra,  tourist places in himachal Pradesh, tourist places in Jaipur,  tourist places in india, tourist places in uttarakhand, tourist places in lucknow, tourist places Noida, tourist places near me ",
]);

$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => 'Discover the best places to visit in Incredible India with Explore Our India. Experience rich culture, vibrant festivals, food, and travel destinations.'], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => 'https://www.exploreourindia.com/backend/web/images/post/big/8337_kashi vishwanath temple varanasi.webp'], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => 'Discover the best places to visit in Incredible India with Explore Our India. Experience rich culture, vibrant festivals, food, and travel destinations.'], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => 'https://www.exploreourindia.com/backend/web/images/post/big/8337_kashi vishwanath temple varanasi.webp'], 'twitter:image');
?>
<div role="main" class="main pt-3 mt-3 bg-color-grey-scale-3">
    <div class="container">
     <div class="row pb-1" style="margin-top:5px;">    
        <div class="col-lg-7 mb-4 pb-2">
             <?=Html::a('<article class="thumb-info thumb-info-no-borders thumb-info-bottom-info thumb-info-bottom-info-dark thumb-info-bottom-info-show-more thumb-info-no-zoom border-radius-0"><div class="thumb-info-wrapper thumb-info-wrapper-opacity-6"> <img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$blogQuery->image.'" class="img-fluid" alt="'.$blogQuery->heading.'"><div class="thumb-info-title bg-transparent p-4"><div class="thumb-info-inner mt-1"><h2 class="font-weight-bold text-color-light line-height-2 text-5 mb-0">'.$blogQuery->heading.'</h2></div><div class="thumb-info-show-more-content"><p class="mb-0 text-1 line-height-9 mb-1 mt-2 text-light opacity-5">'.$blogQuery->limitTextWords(strip_tags($blogQuery->content), 20, true, true).'</p></div></div></div></article>', ['/blog/view', 'slug' => $blogQuery->slug])?>            
		</div>
        <div class="col-lg-5">
		<?php $postqQuery = Blog::find()->where(['status' => 1])->andwhere(['!=', 'id', $blogQuery->id])->orderBy(['id' => SORT_DESC])->limit(3)->all();
		      foreach($postqQuery as $ppostqQuery) {?>
          <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-2 mb-2">
            <div class="row align-items-center pb-1">
              <div class="col-sm-5"> 
                <?php if($ppostqQuery->image != '') {?>
                  <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$ppostqQuery->image.'" alt="'.$ppostqQuery->heading.'" class="lazyload img-fluid border-radius-0" > ', ['/blog/view', 'slug' => $ppostqQuery->slug])?>
			    <?php } else { ?>
				  <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/photo-not-availabe.jpg" class="img-fluid border-radius-0">
				<?php } ?>
			  </div>
              <div class="col-sm-7 pl-sm-1">
                <div class="thumb-info-caption-text">
                  <h2 class="d-block line-height-2 text-4 text-dark font-weight-bold mt-2 mb-0"><?=Html::a($ppostqQuery->heading, ['/blog/view', 'slug' => $ppostqQuery->slug], ['class' => 'text-decoration-none text-color-dark'])?> </h2>
                   <p style="margin:0;"><?=$ppostqQuery->limitTextWords(strip_tags($ppostqQuery->content), 8, true, true)?></p>
                </div>
              </div>
            </div>
          </article>
			<?php } ?>
        </div>
      </div>          
    </div>
  </div>
 
<section class="section bg-white  section-height-1 border-0 m-0">
    <div class="container  py-3">
    <div class="heading  text-center p-3">             
		<h2 class="font-weight-bolder   line-height-1 gradient-text-color"> 
		  <span class="line1 text-4">Discover the Beauty of </span>
		  <span class="line2 text-13"> Incredible India </span>
		</h2>
		<p>India is a land of timeless charm and a traveler’s paradise, where every corner tells a story. From the Himalayas and royal palaces of Rajasthan to Kerala’s backwaters and Goa’s beaches, Incredible India welcomes you with endless wonders of culture, heritage, and natural beauty.</p>
      </div>
      <div class="row"> 
         <div class="owl-carousel owl-theme stage-margin owl-loaded owl-drag owl-carousel-init" data-plugin-options="{'items': 5, 'autoplay': true, 'autoplayTimeout': 4000, 'margin': 10, 'loop': true, 'nav': true, 'dots': false, 'stagePadding': 40}" style="height: auto;">
			 <div class="owl-stage-outer"><div class="owl-stage" style="transform: translate3d(0px, 0px, 0px); transition: all 0.25s ease 0s; width: 1814px; padding-left: 40px; padding-right: 40px;">
                  <?php foreach($modelstate as $modelstateall) {?>
				  <div class="owl-item active" style="width: 163.333px; margin-right: 10px;">
                      <div>
							<?php if($modelstateall->image != '') {?>
							   <?= Html::a("<img src='".Yii::$app->urlManagerBackend->baseUrl.'/images/state/'.$modelstateall->image."' alt='".$modelstateall->state_name."' class='img-fluid rounded mb-2'>",['/state/view/', 'slug' => $modelstateall->slug])  ?>
							<?php } else { ?>
							  <?= Html::a("<img src='".Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg'."' alt='".$modelstateall->state_name."' class='img-fluid rounded mb-2'>",['/state/view/', 'slug' => $modelstateall->slug])  ?>
							<?php } ?>
                            <span>
							<?php 
							  echo Html::button($modelstateall->state_name, [
									'class' => 'btn btn-rounded full-width btn-gradient mb-2 font-weight-bold',
									'onclick' => "window.location.href='" . \yii\helpers\Url::to(['/state/view', 'slug' => $modelstateall->slug]) . "'"
								]);

							?>
							</span>
					  </div>
                   </div>
				   <?php } ?>
              </div></div>
			<div class="owl-nav">
				<button type="button" role="presentation" class="owl-prev disabled"></button>                                
				<button type="button" role="presentation" class="owl-next"></button>
			</div>
			   <div class="owl-dots disabled"></div>
			</div>    
      </div>
      <div class="row">
        <div class="col text-center"><?=Html::a('VIEW ALL STATES IN INDIA', ['/state/index'], ['class' => 'btn btn-primary font-weight-semibold text-3 px-5 btn-py-2'])?></div>
      </div>
    </div>
  </section>
   
  <section class="section bg-color-grey-scale-1 section-height-2 border-0 m-0">
    <div class="container py-3">
      <div class="row">
        <div class="col-lg-12 text-center">
          <h2 class="font-weight-normal mb-0 pb-0">Explore the Spirit of India – <strong class="font-weight-extra-bold"> Traditions to Thrills</strong></h2>          
          <div class="post-meta mt-4">           
			  <span class="alternative-font font-weight-bold text-7">          
			  <span><i class="fas fa-quote-left"></i></span> Heritage, Spirituality, Adventure, and Nature - Experience the True Spirit of India. <i class="fas fa-quote-right"></i></span> 
          </div>
          <p class="pt-3 pb-3">India is a land of heritage, spirituality, adventure, and nature. From ancient forts and sacred sites to thrilling treks, river rafting, and eco-friendly escapes, every journey here tells a unique story. Whether you seek culture, devotion, adrenaline, or peace, India has it all.</p>
        </div>
        
		<div class="col-sm-6 col-lg-3 ">
			<div class="portfolio-item">
				<a href="https://www.exploreourindia.com/category/religious">
					<span class="thumb-info thumb-info-centered-info thumb-info-no-borders border-radius-0">
						<span class="thumb-info-wrapper border-radius-0">
							<img src="<?php echo Yii::$app->urlManagerFrontend->baseUrl.'/images/religious.webp'?>" class="img-fluid border-radius-0" alt="">
							<span class="thumb-info-title">
								<span class="thumb-info-inner">Sacred Spirit Trails</span>
								<span class="thumb-info-type badge-danger badge">Explore Sacred India</span>
							</span>
						</span>
					</span>
				</a>
			</div>
		</div>
		
		<div class="col-sm-6 col-lg-3 ">
			<div class="portfolio-item">
				<a href="https://www.exploreourindia.com/category/heritage">
					<span class="thumb-info thumb-info-centered-info thumb-info-no-borders border-radius-0">
						<span class="thumb-info-wrapper border-radius-0">
							<img src="<?php echo Yii::$app->urlManagerFrontend->baseUrl.'/images/heritage.webp'?>" class="img-fluid border-radius-0" alt="">
							<span class="thumb-info-title">
								<span class="thumb-info-inner">Discover Timeless Heritage</span>
								<span class="thumb-info-type badge-danger badge">Explore Indian Heritage</span>
							</span>
						</span>
					</span>
				</a>
			</div>
		</div>
		
		<div class="col-sm-6 col-lg-3 ">
			<div class="portfolio-item">
				<a href="https://www.exploreourindia.com/category/adventure">
					<span class="thumb-info thumb-info-centered-info thumb-info-no-borders border-radius-0">
						<span class="thumb-info-wrapper border-radius-0">
							<img src="<?php echo Yii::$app->urlManagerFrontend->baseUrl.'/images/adventure.webp'?>" class="img-fluid border-radius-0" alt="">
							<span class="thumb-info-title">
								<span class="thumb-info-inner">Unleash Adventure Thrills</span>
								<span class="thumb-info-type badge-danger badge">Explore Adventure in India</span>
							</span>
						</span>
					</span>
				</a>
			</div>
		</div>
		
		<div class="col-sm-6 col-lg-3 ">
			<div class="portfolio-item">
				<a href="https://www.exploreourindia.com/category/ecotourism">
					<span class="thumb-info thumb-info-centered-info thumb-info-no-borders border-radius-0">
						<span class="thumb-info-wrapper border-radius-0">
							<img src="<?php echo Yii::$app->urlManagerFrontend->baseUrl.'/images/ecotourism.webp'?>" class="img-fluid border-radius-0" alt="">
							<span class="thumb-info-title">
								<span class="thumb-info-inner">Reconnect with Nature</span>
								<span class="thumb-info-type badge-danger badge">Explore Ecotourism in India</span>
							</span>
						</span>
					</span>
				</a>
			</div>
		</div>             
      </div>
    </div>
  </section>
    
  <section class="section sec bg-color-light border-0 m-0 p-4" >
    <div class="container ">
      <div class="row text-center text-md-left mt-0">
        <div class="col-md-12 mb-2 mb-md-0">
          <div class="row justify-content-center justify-content-md-start">
            <div class="col-md-12">     
       <h1 class="font-weight-bold text-center line-height-2 gradient-text-color">
      <span class="line1 text-7"> The Heart of Incredible India </span>
      <span class="line1 text-2"> Culture, Heritage, Travel &amp; Adventure Awaits </span>
       </h1>
       
           <p class="text-center">“Atithi Devo Bhava” – in India, guests are treated as gods, and at Explore Our India, we carry forward this tradition by offering immersive, authentic, and unforgettable journeys across the vast and vibrant land of Incredible India. From the majestic Himalayas in the north to the serene beaches of the south, India is a country of vibrant contrasts where history, spirituality, adventure, and nature blend seamlessly. </p>
           <p class="text-center">Iconic destinations like the Taj Mahal in Agra, the palaces of Rajasthan, the ghats of Varanasi, and the backwaters of Kerala tell unique stories through diverse cuisines, languages, and traditions. While India is beautiful year-round, the cooler months from October to March are ideal for exploring the north, while winter and early summer are perfect for coastal escapes. No matter how you travel, exploring India means discovering a world within a country—rich, diverse, and endlessly fascinating.</p>
           
           
        </div>
          </div>
        </div>
         
      </div>
    </div>
  </section>
  
  
  
  <section class="section section-height-1 bg-light">
    <div class="container">
      
      <div class="row pb-1 pt-1">
        <div class="col-md-12">
        <h3 class="font-weight-bold text-center line-height-2 gradient-text-color">
      <span class="line1 text-1"> Explore India’s Divine Spirit </span>
      <span class="line1 text-4 pb-1"> Religious Tourism in India </span>
       </h3>
       <div class="text-center pt-2 pb-2">
        <span class="alternative-font font-weight-bold text-7">
          <span><i class="fas fa-quote-left"></i></span> Explore the Spiritual Heartbeat of India. <span><i class="fas fa-quote-right"></i></span></span>
                </div>
                   
          <p class="text-center">India is home to some of the world’s most sacred and spiritual destinations. From the holy ghats of Varanasi and the grand Golden Temple in Amritsar to the sacred Meenakshi Temple in Madurai, the majestic Somnath Jyotirlinga, the Ajmer Sharif Dargah, and the peaceful monasteries of Ladakh, every faith finds its divine presence here. With thousands of temples, mosques, gurudwaras, churches, and monasteries spread across the country, India offers a spiritual journey like no other where devotion meets history, culture, and tradition.</p>
          
          <div class="row pb-1">
            <div class="col-lg-2 hover mb-0 mx-3"> <a href="https://www.exploreourindia.com/tag/temple"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4 " src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/temple.webp" alt="Temple"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Temple</span></h4>
              </span></a> </div>
            <div class="col-lg-2 hover mb-0 mx-3"> <a href="https://www.exploreourindia.com/tag/gurudwara"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4" src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/gurudwara.webp" alt="Gurudwara"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Gurudwara</span></h4>
              </span></a> </div>
            <div class="col-lg-2 hover mb-0 mx-3"> <a href="https://www.exploreourindia.com/tag/church"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4" src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/church.webp" alt="Church"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Church</span></h4>
              </span></a> </div>
            <div class="col-lg-2 hover mb-0 mx-3"> <a href="https://www.exploreourindia.com/tag/mosque"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4" src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/mosque.webp" alt="Mosque"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Mosque</span></h4>
              </span></a> </div>
              
              <div class="col-lg-2 hover mb-0 mx-3"> <a href="#"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4" src="img/mosque.webp" alt="monastery"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Monastery</span></h4>
              </span></a> </div>            
          </div>          
        </div>       
      </div>      
    </div>
  </section>  
  
  <section class="call-to-action call-to-action-default with-button-arrow content-align-center call-to-action-in-footer call-to-action-in-footer-margin-top mt-0 pt-4" style="background:#ff671f">
    <div class="container">
      <div class="row">
        <div class="col-md-9 col-lg-9">
          <div class="col-md-12 col-lg-11">
            <div class="call-to-action-content">
              <h4 class="word-rotator slide font-weight-bold text-7 mb-2 appear-animation animated fadeInUpShorter appear-animation-visible" data-appear-animation="fadeInUpShorter" style="animation-delay: 100ms;"> <span class="pb-3"> <i class="fas fa-quote-left "></i> Your Story, Our Inspiration <i class="fas fa-quote-right"></i></span><br>
                <span>Share Your Travel </span> <span class="word-rotator-words bg-dark"> <b class="is-visible">Story</b> <b class="is-hidden">Journey</b> <b class="is-hidden">Experience</b> <b class="is-hidden">Adventure</b> <b class="is-hidden">Memories</b> <b class="is-hidden">Exploration</b> </span> <span> – Inspire Fellow Explorers </span> </h4>
              <p class="mb-0 text-color-light p-3 text-3 line-height-5"> Travel is more than just visiting destinations it’s about the journeys, experiences, and memories we create along the way. From breathtaking landscapes to cultural encounters, your travel experiences can inspire fellow explorers to embark on their own adventures. Share your travel story and let the world see the magic through your eyes.</p>
            </div>
          </div>
        </div>
        <div class="col-md-3 col-lg-3">
          <div class="call-to-action-btn">
            <?=Html::a('Share Your Travel Story', FALSE, ['value' => Url::to(['/site/sharestories']), 'class' => 'open-btn btn btn-dark btn-lg text-3 font-weight-semibold px-4 py-3 buttonmodalquery', 'title' => 'Share Your Travel Story']);?>
            <span class="arrow hlb d-none d-md-block appear-animation animated rotateInUpLeft appear-animation-visible" data-appear-animation="rotateInUpLeft" style="top: -40px; left: 70%; animation-delay: 100ms;"></span>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="section section-height-3 bg-color-grey-scale-1 border-0 m-0 appear-animation animated fadeIn appear-animation-visible" data-appear-animation="fadeIn" style="animation-delay: 100ms;">
    <div class="container">
      <h3 class="text-4 gradient-text-color text-center"> <strong class="font-weight-bold text-10 text-light px-3 py-2 line-height-1 "> <i class="fas fa-quote-left"></i> What Our Travelers Say <i class="fas fa-quote-right"></i></strong></h3>
      <p class="text-center text-7 font-weight-bold alternative-font mt-3 mb-3"><i>Real reviews and experiences from happy explorers across India & beyond.</i></p>
      <div class="row">
        <div class="col appear-animation animated fadeInUpShorter appear-animation-visible" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="200" style="animation-delay: 200ms;">
          <div class="owl-carousel owl-theme stage-margin stage-margin-lg nav-dark nav-style-2 mb-0 owl-loaded owl-drag owl-carousel-init" data-plugin-options="{'items': 1, 'margin': 100, 'loop': false, 'nav': true, 'dots': false, 'stagePadding': 100, 'autoHeight': true}" style="height: auto;">
            <div class="owl-stage-outer owl-height" style="height: 274.112px;">
              <div class="owl-stage" style="transform: translate3d(0px, 0px, 0px); transition: all 0.25s ease 0s; width: 2220px; padding-left: 100px; padding-right: 100px;">
                <?php $i=1;
				 foreach($travelstory as $travelstories) {
				?>
				<div class="owl-item <?php if($i == 1) {?>active<?php } ?>" style="width: 910px; margin-right: 100px;">
                  <div>
                    <div class="testimonial testimonial-style-2 mb-0">
                      <div class="testimonial-author"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/tarvel-story-img/<?=$travelstories->img?>" alt="<?=$travelstories->name?>"> </div>
                      <blockquote>
                        <p class="text-color-dark text-5 line-height-5 mb-0"><?=$travelstories->message?></p>
                      </blockquote>
                      <div class="testimonial-author">
                        <p><strong class="font-weight-extra-bold text-2">- <?=$travelstories->name?></strong></p>
                      </div>
                    </div>
                  </div>
                </div>
				<?php $i++; } ?>
              </div>
            </div>
            <div class="owl-nav">
              <button type="button" role="presentation" class="owl-prev disabled"></button>
              <button type="button" role="presentation" class="owl-next"></button>
            </div>
            <div class="owl-dots disabled"></div>
          </div>
        </div>
      </div>
    </div>
  </section>
  
  <section class="section sec bg-color-light border-0 m-0 p-4" >
    <div class="container container-lg">
      <div class="row text-center text-md-left mt-0">
        <div class="col-md-12 mb-2 mb-md-0">
  <div class="appear-animation animated fadeInUpShorter appear-animation-visible" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="200" style="animation-delay: 200ms;">
  
  
  <div class="container">
  <h3 class="font-weight-bold text-center line-height-2 gradient-text-color">
      <span class="line1 text-1"> Turn Travel Dreams into Memories </span>
      <span class="line1 text-4 pb-1"> A 4-Step Journey Across India </span>
       </h3>
       
       <p class="text-center">Turn your travel dreams into unforgettable memories across India. Pick inspiring destinations. Plan with expert tips. Explore culture, adventure, and nature. Cherish every moment. From heritage sites to ecotourism and adventure thrills, our 4-step journey makes every trip seamless, inspiring, and truly memorable. Start exploring India today!</p>
  </div>
  
					<div class="home-concept mt-5">
						<div class="container">
				
							<div class="row text-center">
								<span class="sun"></span>
								<span class="cloud" style="top: 54.1067px;"></span>
								<div class="col-lg-2 ml-lg-auto">
									<div class="process-image">
										<img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/dream.png" alt="">
										<strong class="alternative-font">Dream</strong>
                                        <p>Pick the destinations that inspire you.</p>
									</div>
								</div>
								<div class="col-lg-2">
									<div class="process-image process-image-on-middle">
										<img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/plan.png" alt="">
										<strong class="alternative-font">Plan</strong>
                                        <p>Explore guides, tips, and best routes.</p>
									</div>
								</div>
								<div class="col-lg-2">
									<div class="process-image">
										<img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/explore-1.png" alt="">
										<strong class="alternative-font">Explore</strong>
                                        <p>Experience culture, adventure, and nature.</p>
									</div>
								</div>
								<div class="col-lg-4 ml-lg-auto">
									<div class="project-image">
										<div id="fcSlideshow" class="fc-slideshow">
											<ul class="fc-slides">
												<li style="display: none;"><a href="#"><img class="img-responsive" src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/cherrish.png" width="100%" alt=""></a></li>
												<li style="display: list-item;"><a href="#"><img class="img-responsive" src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/cherrish-2.png" width="100%" alt=""></a></li>
												<li style="display: none;"><a href="#"><img class="img-responsive" src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/cherrish-01.png" width="100%" alt=""></a></li>
											</ul>
										<nav><div class="fc-left"><span></span><span></span><span></span><i class="fa fa-arrow-left"></i></div><div class="fc-right"><span></span><span></span><span></span><i class="fa fa-arrow-right"></i></div></nav><div class="fc-flip" style="transition: none 0s ease 0s; transform: none; display: none;"><div class="fc-front"><div><a href="portfolio-single-wide-slider.html"><img class="img-responsive" src="img/projects/project-home-1.jpg" alt=""></a></div><div class="fc-overlay-light" style="transition: opacity 538.462ms ease 0s; opacity: 1;"></div></div><div class="fc-back" style="transform: rotate3d(1, 1, 0, 180deg);"><div><a href="portfolio-single-wide-slider.html"><img class="img-responsive" src="img/projects/project-home-2.jpg" alt=""></a></div><div class="fc-overlay-dark" style="opacity: 0; transition: opacity 538.462ms ease 0s;"></div></div></div></div>
										<strong class="alternative-font pt-4">Cherish</strong>
                                        <p>Carry memories that last forever.</p>
									</div>
								</div>
							</div>
				
						</div>
					</div>
				</div>
  </div>
  </div>
  </div>
  </section>
  
  
   <section class="section section-height-2 border-0 m-0 appear-animation animated fadeIn appear-animation-visible" >
    <div class="container">
      <div class="row">
  <div class="col-md-12">
  
    <h3 class="font-weight-bold text-10 text-center line-height-2 gradient-text-color">
      <span class="line1 text-8"> Adventure Tourism in India</span>
      <span class="line1 text-2 pb-1"> Thrilling Activities and Top Destinations </span> 
       </h3>
       <div class="text-center pt-2 pb-2">
          <span class="alternative-font font-weight-bold text-7">
          <span><i class="fas fa-quote-left"></i></span> From Peaks to Oceans – Adventure Awaits in India. <span><i class="fas fa-quote-right"></i></span></span>
        </div>  
        
          <p class="text-center">Adventure tourism in India offers everything from the snowy peaks of the Himalayas to the blue waters of Goa and Andaman. Thrill seekers can enjoy trekking, rafting, paragliding, skiing, bungee jumping, scuba diving, camping, and wildlife safaris across stunning landscapes. With activities like motorbike expeditions, zip-lining, kayaking, and water sports, India is a true paradise for adventurers.</p>
          
          <div class="row pb-1 mt-4">
            <div class="col-lg-6 mb-4 pb-1">
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-2 mb-2">
                <div class="row">
                  <div class="col">
                    <?=Html::a('<img src='.Yii::$app->urlManagerBackend->baseUrl.'/images/tag/big/'.$TagoneQuery->image.' alt="'.$TagoneQuery->name.'" class="lazyload img-fluid border-radius-0"> ', ['/tag/view', 'slug' => $TagoneQuery->slug])?>
				  </div>
                </div>
                <div class="row">
                  <div class="col">
                    <div class="thumb-info-caption-text">
                      <h4 class="d-block line-height-2 text-4 text-dark font-weight-bold mb-0 mt-2"> <?=Html::a($TagoneQuery->name, ['/tag/view', 'slug' => $TagoneQuery->slug], ['class' => 'text-decoration-none text-color-dark'])?> </h4>
                    </div>
                  </div>
                </div>
              </article>
            </div>
			<div class="col-lg-3">
			 <?php
             $TagoddQQuery = Tag::find()->where(['status' => 1])->where(['between', 'id', 1, 12])->andwhere(['!=', 'id', 2])->andwhere(['!=', 'id', $TagoneQuery->id])->andwhere(['%2<>','id',0])->orderBy('id')->limit(5)->all();    
			 foreach($TagoddQQuery as $tagdisplay) {?>
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4"> <?=Html::a('<img src='.Yii::$app->urlManagerBackend->baseUrl.'/images/tag/small/'.$tagdisplay->image.' alt="'.$tagdisplay->name.'" class="lazyload img-fluid border-radius-0"> ', ['/tag/view', 'slug' => $tagdisplay->slug])?>
				  </div>
                  <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                     
                      <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0 pt-1"> <?=Html::a($tagdisplay->name, ['/tag/view', 'slug' => $tagdisplay->slug], ['class' => 'text-decoration-none text-color-dark'])?></h4>
                    </div>
                  </div>
                </div>
              </article>
			 <?php } ?>
            </div>
            <div class="col-lg-3">
			 <?php
             $TagevenQQuery = Tag::find()->where(['status' => 1])->where(['between', 'id', 1, 12])->andwhere(['!=', 'id', 2])->andwhere(['!=', 'id', $TagoneQuery->id])->andwhere(['%2=','id',0])->orderBy('id')->limit(5)->all();  
			 foreach($TagevenQQuery as $tagdisplay) {?>
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4"> <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/tag/small/'.$tagdisplay->image.'" alt="'.$tagdisplay->name.'" class="lazyload img-fluid border-radius-0"> ', ['/tag/view', 'slug' => $tagdisplay->slug])?>
				  </div>
                  <div class="col-sm-7 pl-sm-0">
                    <div class="thumb-info-caption-text">                     
                      <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0 pt-1"> <?=Html::a($tagdisplay->name, ['/tag/view', 'slug' => $tagdisplay->slug], ['class' => 'text-decoration-none text-color-dark'])?></h4>
                    </div>
                  </div>
                </div>
              </article>
			 <?php } ?>
            </div>			
          </div>
          </div>
  </div>
  </div>
  </section>
  
  <div role="main" class="main pt-3 mt-3 ">
    <div class="container">
      <div class="row pb-1 pt-2">
        <!--<div class="col-md-12">
          <div class="heading heading-border heading-middle-border">
            <h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-quaternary">REligious Places in India</strong></h3>
          </div>
          <p class="text-center">India is home to some of the world’s most sacred and spiritual destinations. From the holy ghats of Varanasi and the grand Golden Temple in Amritsar to the sacred Meenakshi Temple in Madurai, the majestic Somnath Jyotirlinga, the Ajmer Sharif Dargah, and the peaceful monasteries of Ladakh, every faith finds its divine presence here. With thousands of temples, mosques, gurudwaras, churches, and monasteries spread across the country, India offers a spiritual journey like no other where devotion meets history, culture, and tradition.</p>
          
          <div class="row pb-1">
            <div class="col-lg-2 hover mb-5 mx-3"> <a href="#"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4 " src="img/temple.webp" alt="Temple"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Temple</span></h4>
              </span></a> </div>
            <div class="col-lg-2 hover mb-5 mx-3"> <a href="#"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4" src="img/gurudwara.webp" alt="Gurudwara"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Gurudwara</span></h4>
              </span></a> </div>
            <div class="col-lg-2 hover mb-5 mx-3"> <a href="#"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4" src="img/church.webp" alt="Church"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Church</span></h4>
              </span></a> </div>
            <div class="col-lg-2 hover mb-5 mx-3"> <a href="#"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4" src="img/mosque.webp" alt="Mosque"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Mosque</span></h4>
              </span></a> </div>
              
              <div class="col-lg-2 hover mb-5 mx-3"> <a href="#"> <span class="bdrhvr hover14">
              <figure> <img class="img-fluid rounded-circle mb-4" src="img/mosque.webp" alt="Mosque"> </figure>
              <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Monestry</span></h4>
              </span></a> </div>
            <style>
			.bdrhvr img:hover{
				border:5px solid #FC0}
				.bdrhvr img{
				border:5px solid #CCC}
				
				.hover {
  --c: #ff4400; /* the color */
  --s: .35em;
  
  line-height:1.1em;
  padding-bottom: calc(2.1*var(--s));
  background: 
    conic-gradient(from 135deg at top,var(--c) 90deg,#0000 0) 
      left 0 bottom var(--s)/calc(2*var(--s)) var(--s) repeat-x,
    conic-gradient(from -45deg at bottom,var(--c) 90deg,#0000 0) 
      left var(--s) bottom 0/calc(2*var(--s)) var(--s) repeat-x;
  -webkit-mask:
    linear-gradient(#000 0 0) content-box,
    linear-gradient(#000 0 0) 0/var(--_p,0%) padding-box no-repeat;
  transition: .5s;
  
}
.hover:hover {
  --_p: 100%;
  color: var(--c);
}


h3 {
  font-family: system-ui, sans-serif;
  font-size: 4rem;
  margin:0;
  cursor: pointer;
  padding: 0 .1em;
}


.hover14 figure {
	position: relative;
}
.hover14 figure::before {
	position: absolute;
	top: 0;
	left: -75%;
	z-index: 2;
	display: block;
	content: '';
	width: 50%;
	height: 100%;
	background: -webkit-linear-gradient(left, rgba(255,255,255,0) 0%, rgba(255,255,255,.3) 100%);
	background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,.3) 100%);
	-webkit-transform: skewX(-25deg);
	transform: skewX(-25deg);
}
.hover14 figure:hover::before {
	-webkit-animation: shine .75s;
	animation: shine .75s;
}
@-webkit-keyframes shine {
	100% {
		left: 125%;
	}
}
@keyframes shine {
	100% {
		left: 125%;
	}
}



			</style>
          </div>
          
        </div>-->
        <div class="col-md-9">
        
        <h3 class="font-weight-bold text-10 line-height-2 gradient-text-color">
      <span class="line1 text-7"> Heritage Places in India </span>
      <span class="line1 text-2 pb-1">  Monuments, Forts, Palaces & Ancient Wonders </span>
       </h3>
       <div class="pt-2 pb-2">
        <span class="alternative-font font-weight-bold text-7">
          <span><i class="fas fa-quote-left"></i></span> Discover Timeless Stories Through India’s Heritage <span><i class="fas fa-quote-right"></i></span></span>
                </div>
  
          <div class="row pb-1">
            <div class="col-lg-12">
              <div class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
              <?=Html::a('<img src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/heritage211.gif" alt="Uncover India’s Rich Heritage – Forts, Palaces, Temples & Historical Wonders" class="img-fluid border-radius-0"> ', ['/category/view', 'slug' => 'heritage'])?>
                <p class="mb-4 mt-3"> India’s heritage is a rich mosaic of majestic forts, ancient temples, royal palaces, and UNESCO World Heritage Sites. From the Taj Mahal to the Ajanta and Ellora caves, each monument echoes the country’s glorious past and architectural brilliance. Exploring these historic treasures offers a deep dive into India’s timeless culture and traditions. </p>
              </div>
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
               <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/taj-mahal"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/taj-mahal-Agra.gif" class="img-fluid border-radius-0" alt="Taj mahal, Agra"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/taj-mahal" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0"> Taj mahal, Agra </h4>
                      <p>Taj Mahal is the epitome of grandeur and splendor, you cannot fathom the beauty of this white-marbled monument unless you stand in front of it. As you approach the Taj Mahal, it gradually becomes known to you that this is no ordinary monument, but a vision come to life! Moved by its beauty and the deep affection of Shah Jahan for Mumtaz, the Nobel Laureate Rabindranath Tagore called it "a teardrop on the face of eternity".</p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
              
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/red-fort"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/red-fort-delhi.gif" class="img-fluid border-radius-0" alt="Red Fort, Delhi"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/red-fort" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0">Red Fort, Delhi </h4>
                      <p>The Red Fort is a historical fortification in the old Delhi area. Shah Jahan constructed it in the year 1639 as a result of a capital shift from Agra to Delhi. Used as the main residence of the emperors of the Mughal dynasty, this imposing piece of architecture derives its name from its impregnable red sandstone walls. In addition to accommodating the emperors and their households, it was the ceremonial and political center of the Mughal state and the setting for events critically impacting the region. </p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
              
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/rani-ki-vav"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/rani-ki-vav-gujarat.gif" class="img-fluid border-radius-0" alt="Rani-ki-Vav, Gujarat"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/rani-ki-vav" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0 ">Rani-ki-Vav, Gujarat </h4>
                        
                      <p>Rani-ki-Vav, on the banks of the Saraswati River, was initially built as a memorial to a king in the 11th century AD. Stepwells are a distinctive form of subterranean water resource and storage systems on the Indian subcontinent and have been constructed since the 3rd millennium BC. </p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
              
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/kaziranga-national-park-and-tiger-reserve"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/kaziranga-national-park-assam.gif" class="img-fluid border-radius-0" alt="Kaziranga National Park, Assam"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/kaziranga-national-park-and-tiger-reserve" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0"> Kaziranga National Park, Assam </h4>
                      <p>All those who have thought Indian one-horned rhinoceros only existed in the Jurassic era, then a trip to Kaziranga is a must for them. One of the most sought-after wildlife holiday destinations in India, Kaziranga National park’s 430 square kilometer area sprinkled with elephant-grass meadows, swampy lagoons, and dense forests are home to more than 2200 Indian one-horned rhinoceros, approximately 2/3rd of their total world population.</p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
              
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/khangchendzonga-national-park"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/khangchendzonga-national-park-sikkim.gif" class="img-fluid border-radius-0" alt="Khangchendzonga National Park, Sikkim"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/khangchendzonga-national-park" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0 ">Khangchendzonga National Park, Sikkim </h4>
                        
                      <p>Khangchendzonga National Park is a UNESCO World Heritage Site and it covers an area of 1784 sq km. This high-altitude national park in Yuksom is known for its spectacular wildlife where exotic animal species such as Red Panda, Snow Leopard, Great Tibetan Sheep, Bharal, Musk deer, etc can be spotted. </p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
              <?=Html::a('Read more Heritage', ['/category/view', 'slug' => 'heritage'], ['class' => 'btn btn-primary btn-block mb-1', 'style' => 'margin-top:-35px;'])?>
              <br><br>
              
            </div>
          </div>
          
          
  <div class="row">
	<div class="col">
       <h3 class="font-weight-bold text-10 line-height-2 gradient-text-color">
      <span class="line1 text-7"> Ecotourism in India </span>
      <span class="line1 text-2 pb-1">  Best Nature, Wildlife & Leisure Experiences </span>
       </h3>
       <div class="pt-2 pb-2">
          <span class="alternative-font font-weight-bold text-7">
          <span><i class="fas fa-quote-left"></i></span> Protecting nature today is preserving travel for tomorrow <span><i class="fas fa-quote-right"></i></span></span>
       </div>
      <p> Ecotourism in India combines nature, wildlife, and leisure, offering travelers sustainable and meaningful journeys. From the backwaters of Kerala and the lush Western Ghats to Himalayan valleys and sanctuaries like Jim Corbett and Kaziranga, India is a true green paradise. Whether trekking, bird-watching, going on safaris, or relaxing in eco-friendly resorts, every experience reconnects you with nature while promoting responsible travel.</p>
		
          
                          <div class="row">
                              <div class="col-lg-4">
                                  <div class="tabs tabs-vertical tabs-left tabs-navigation">
                                      <ul class="nav nav-tabs col-sm-3">
                                          <li class="nav-item active">
                                              <a class="nav-link active" href="#tabsNavigation1" data-toggle="tab"> <strong>🌳 National Parks</strong> </a>
                                          </li>
                                          <li class="nav-item">
                                              <a class="nav-link" href="#tabsNavigation2" data-toggle="tab"> <strong>🐅 Wildlife Sanctuaries</strong></a>
                                          </li>
                                          <li class="nav-item">
                                              <a class="nav-link" href="#tabsNavigation3" data-toggle="tab"> <strong>🏖️ Beaches</strong></a>
                                          </li>
                                          <li class="nav-item">
                                              <a class="nav-link" href="#tabsNavigation4" data-toggle="tab"> <strong>🏞️ Lakes</strong></a>
                                          </li>
                                          <li class="nav-item">
                                              <a class="nav-link" href="#tabsNavigation5" data-toggle="tab"> <strong>🌊 Waterfalls</strong></a>
                                          </li>
                                          <li class="nav-item">
                                              <a class="nav-link" href="#tabsNavigation6" data-toggle="tab"> <strong>🏝️ Islands</strong></a>
                                          </li>
                                      </ul>
                                  

                                  </div>
                              </div>
                              <div class="col-lg-8 tab-content">
                                  <div class="tab-pane tab-pane-navigation active" id="tabsNavigation1">
                                      <h4>Explore the Famous National Parks of India</h4>
                                      <p>India’s national parks protect tigers, elephants, rhinos, and rare birds, offering safaris, stunning landscapes, and unforgettable wildlife experiences across diverse habitats.</p>
                                      <?php
                                        $PostrelQuery = Post::find()->where(['status' => 1])->andWhere('FIND_IN_SET(80, tag_id)')->orderBy('id')->limit(2)->all();
                                        foreach($PostrelQuery as $PostrelQueryy) {
                                      ?>
                                      <div class="col-12 col-sm-6 col-lg-6 float-left" >
                                       <span class="thumb-info thumb-info-hide-wrapper-bg mb-4">
                                         <span class="thumb-info-wrapper">
                                         <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$PostrelQueryy->image.'" alt="'.$PostrelQueryy->title.'" class="lazyload img-fluid"> ', ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                         </span> 
                                         <span class="thumb-info-caption">
                                          <h4 class="gradient-text-color font-weight-semibold text-3 line-height-6 mt-2 mb-2">
                                          <?=Html::a($PostrelQueryy->title, ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                          </h4>
                                         </span>
                                         </span> 
                                      </div>
                                        <?php } ?>                                      
                                       <span>
                                         <?=Html::a('Explore National Parks', ['/tag/view', 'slug' => 'national-park'], ['class' => 'btn btn-rounded full-width btn-gradient mb-2 font-weight-bold', 'style' => 'width:100%'])?>
                                      </span>
                                  </div>
                                  
                                  
                                  <div class="tab-pane tab-pane-navigation" id="tabsNavigation2">
                                      <h4>Explore the Wildlife Sanctuaries of India</h4>
                                      <p>India’s wildlife sanctuaries, from Gir to Ranthambore, protect rare species and offer safaris, bird watching, and nature walks, letting travelers reconnect with biodiversity and India’s wild beauty.</p>
                                       <?php
                                        $PostrelQuerywild = Post::find()->where(['status' => 1])->andWhere('FIND_IN_SET(81, tag_id)')->orderBy('id')->limit(2)->all();
                                        foreach($PostrelQuerywild as $PostrelQueryy) {
                                      ?>
                                      <div class="col-12 col-sm-6 col-lg-6 float-left" >
                                       <span class="thumb-info thumb-info-hide-wrapper-bg mb-4">
                                         <span class="thumb-info-wrapper">
                                         <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$PostrelQueryy->image.'" alt="'.$PostrelQueryy->title.'" class="lazyload img-fluid"> ', ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                         </span> 
                                         <span class="thumb-info-caption">
                                          <h4 class="gradient-text-color font-weight-semibold text-3 line-height-6 mt-2 mb-2">
                                          <?=Html::a($PostrelQueryy->title, ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                          </h4>
                                         </span>
                                         </span> 
                                      </div>
                                        <?php } ?>                                      
                                       <span>
                                         <?=Html::a('Explore wildlife sanctuaries', ['/tag/view', 'slug' => 'wildlife-sanctuary'], ['class' => 'btn btn-rounded full-width btn-gradient mb-2 font-weight-bold', 'style' => 'width:100%'])?>
                                      </span>
                                  </div>
                                  <div class="tab-pane tab-pane-navigation" id="tabsNavigation3">
                                      <h4>Explore India’s Stunning Beaches</h4>
                                      <p>India’s beaches, from Goa and Kovalam to Radhanagar and Marina, offer sun, sand, water sports, and serene sunsets, perfect for relaxation, adventure, and coastal exploration.</p>
                                       <?php
                                        $PostrelQueryBeach = Post::find()->where(['status' => 1])->andWhere('FIND_IN_SET(79, tag_id)')->orderBy('id')->limit(2)->all();
                                        foreach($PostrelQueryBeach as $PostrelQueryy) {
                                      ?>
                                      <div class="col-12 col-sm-6 col-lg-6 float-left" >
                                       <span class="thumb-info thumb-info-hide-wrapper-bg mb-4">
                                         <span class="thumb-info-wrapper">
                                         <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$PostrelQueryy->image.'" alt="'.$PostrelQueryy->title.'" class="lazyload img-fluid"> ', ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                         </span> 
                                         <span class="thumb-info-caption">
                                          <h4 class="gradient-text-color font-weight-semibold text-3 line-height-6 mt-2 mb-2">
                                          <?=Html::a($PostrelQueryy->title, ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                          </h4>
                                         </span>
                                         </span> 
                                      </div>
                                        <?php } ?>                                      
                                       <span>
                                         <?=Html::a('Explore Beaches', ['/tag/view', 'slug' => 'beach'], ['class' => 'btn btn-rounded full-width btn-gradient mb-2 font-weight-bold', 'style' => 'width:100%'])?>
                                      </span>
                                  </div>
                                  
                                  
                                  <div class="tab-pane tab-pane-navigation" id="tabsNavigation4">
                                      <h4>Explore the Most Beautiful Lakes of India</h4>
                                      <p>India’s lakes, from Dal and Naini to Chilika and Vembanad, offer boating, bird-watching and leisure escapes, blending natural charm, culture and tranquility for travelers to explore and relax.</p>
                                      <?php
                                        $PostrelQueryLake = Post::find()->where(['status' => 1])->andWhere('FIND_IN_SET(21, tag_id)')->orderBy('id')->limit(2)->all();
                                        foreach($PostrelQueryLake as $PostrelQueryy) {
                                      ?>
                                      <div class="col-12 col-sm-6 col-lg-6 float-left" >
                                       <span class="thumb-info thumb-info-hide-wrapper-bg mb-4">
                                         <span class="thumb-info-wrapper">
                                         <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$PostrelQueryy->image.'" alt="'.$PostrelQueryy->title.'" class="lazyload img-fluid"> ', ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                         </span> 
                                         <span class="thumb-info-caption">
                                          <h4 class="gradient-text-color font-weight-semibold text-3 line-height-6 mt-2 mb-2">
                                          <?=Html::a($PostrelQueryy->title, ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                          </h4>
                                         </span>
                                         </span> 
                                      </div>
                                        <?php } ?>                                      
                                       <span>
                                         <?=Html::a('Explore Lakes', ['/tag/view', 'slug' => 'lake'], ['class' => 'btn btn-rounded full-width btn-gradient mb-2 font-weight-bold', 'style' => 'width:100%'])?>
                                      </span>                                                                             
                                  </div>
                                  <div class="tab-pane tab-pane-navigation" id="tabsNavigation5">
                                      <h4>Discover India’s Majestic Waterfalls</h4>
                                      <p>India’s waterfalls, like Jog, Dudhsagar, and Athirappilly, mesmerize travelers with their beauty and power, offering adventure, nature walks, and serene spots for relaxation and photography.</p>
                                      <?php
                                        $PostrelQueryWaterfalls = Post::find()->where(['status' => 1])->andWhere('FIND_IN_SET(82, tag_id)')->orderBy('id')->limit(2)->all();
                                        foreach($PostrelQueryWaterfalls as $PostrelQueryy) {
                                      ?>
                                      <div class="col-12 col-sm-6 col-lg-6 float-left" >
                                       <span class="thumb-info thumb-info-hide-wrapper-bg mb-4">
                                         <span class="thumb-info-wrapper">
                                         <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$PostrelQueryy->image.'" alt="'.$PostrelQueryy->title.'" class="lazyload img-fluid"> ', ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                         </span> 
                                         <span class="thumb-info-caption">
                                          <h4 class="gradient-text-color font-weight-semibold text-3 line-height-6 mt-2 mb-2">
                                          <?=Html::a($PostrelQueryy->title, ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                          </h4>
                                         </span>
                                         </span> 
                                      </div>
                                        <?php } ?>                                      
                                       <span>
                                         <?=Html::a('Explore Waterfalls', ['/tag/view', 'slug' => 'waterfalls'], ['class' => 'btn btn-rounded full-width btn-gradient mb-2 font-weight-bold', 'style' => 'width:100%'])?>
                                      </span>                                        
                                  </div>
                                  <div class="tab-pane tab-pane-navigation" id="tabsNavigation6">
                                      <h4>Explore India’s Stunning Islands</h4>
                                      <p>India’s islands, including Andaman, Lakshadweep, and Majuli, offer pristine beaches, rich culture, and adventure. Travelers can enjoy snorkeling, wildlife, water sports, and unforgettable tropical experiences.</p>
                                      <?php
                                        $PostrelQueryIslands = Post::find()->where(['status' => 1])->andWhere('FIND_IN_SET(90, tag_id)')->orderBy('id')->limit(2)->all();
                                        foreach($PostrelQueryIslands as $PostrelQueryy) {
                                      ?>
                                      <div class="col-12 col-sm-6 col-lg-6 float-left" >
                                       <span class="thumb-info thumb-info-hide-wrapper-bg mb-4">
                                         <span class="thumb-info-wrapper">
                                         <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$PostrelQueryy->image.'" alt="'.$PostrelQueryy->title.'" class="lazyload img-fluid"> ', ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                         </span> 
                                         <span class="thumb-info-caption">
                                          <h4 class="gradient-text-color font-weight-semibold text-3 line-height-6 mt-2 mb-2">
                                          <?=Html::a($PostrelQueryy->title, ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                          </h4>
                                         </span>
                                         </span> 
                                      </div>
                                        <?php } ?>                                      
                                       <span>
                                         <?=Html::a('Explore Islands', ['/tag/view', 'slug' => 'island'], ['class' => 'btn btn-rounded full-width btn-gradient mb-2 font-weight-bold', 'style' => 'width:100%'])?>
                                      </span>                                       
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>         
          
        </div>
        <div class="col-md-3">
          <div class="heading heading-border heading-middle-border">
				<h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Popular Blogs</strong></h3>
			  </div>
          <div class="pb-2">
           <?php $i=1; foreach($popularBlog as $popularBlogg) {?>
            <div class="mb-4 pb-2">
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-2 mb-2">
                <div class="row">
                  <div class="col">
                  <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$popularBlogg->image.'" alt="'.$popularBlogg->heading.'" class="lazyload img-fluid border-radius-0">', ['/blog/view', 'slug' => $popularBlogg->slug])?>
                  </div>
                </div>
                <div class="row">
                  <div class="col">
                    <div class="thumb-info-caption-text">
                      <h4 class="d-block line-height-2 text-4 mt-2 text-dark font-weight-bold mb-0">
                        <?=Html::a($popularBlogg->heading, ['/blog/view', 'slug' => $popularBlogg->slug], ['class' => 'text-decoration-none text-color-dark'])?>
                      </h4>
                    </div>
                  </div>
                </div>
              </article>
            </div>
           <?php } ?>
          </div>
        </div>
      </div>
      </div>
  </div>
  
  <div role="main" class="main pt-3 mt-3">
    <div class="container">
      <div class="row pb-3">
        <div class="col-md-12">
          <div class="row pb-1 pt-3">
            <div class="col-md-4">
              <div class="heading heading-border heading-middle-border">
				<h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Popular Travel Stories</strong></h3>
			  </div>
              <ul class="simple-post-list">
                <?php foreach($popularpost as $popularposts) {?>
				  <li>
					  <article>
						<div class="post-image">
						  <div class="img-thumbnail img-thumbnail-no-borders d-block">
							 <?php if($popularposts->image != '') {?>
							  <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$popularposts->image.'" alt="'.$popularposts->title.'" class="lazyload border-radius-0 popularimg"> ', ['/post/view', 'slug' => $popularposts->slug])?>
							<?php } else { ?>
							   <?=Html::a('<img src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg" alt="'.$popularposts->title.'" class="border-radius-0 popularimg"> ', ['/post/view', 'slug' => $popularposts->slug])?>
							<?php } ?> 
						  </div>
						</div>
						<div class="post-info">
						  <h4 class="font-weight-normal text-3 mb-0" style="line-height:22px">
						  <?=Html::a($popularposts->title, ['/post/view', 'slug' => $popularposts->slug], ['class' => 'text-dark'])?>
						  </h4>
						</div>
					  </article>
					</li>
				<?php } ?>
              </ul>
            </div>
            <div class="col-md-4">
              <div class="heading heading-border heading-middle-border">
				<h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Explore Recent Blogs</strong></h3>
			  </div>
              <ul class="simple-post-list">
                <?php foreach($recentBlog as $recentBlogg) {?>
				  <li>
					  <article>
						<div class="post-image">
						  <div class="img-thumbnail img-thumbnail-no-borders d-block">
							 <?php if($recentBlogg->image != '') {?>
							  <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$recentBlogg->image.'" alt="'.$recentBlogg->heading.'" class="lazyload border-radius-0 popularimg">', ['/blog/view', 'slug' => $recentBlogg->slug])?>
							<?php } else { ?>
							   <?=Html::a('<img src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg" alt="'.$recentBlogg->heading.'" class="lazyload border-radius-0 popularimg"> ', ['/blog/view', 'slug' => $recentBlogg->slug])?>
							<?php } ?> 
						  </div>
						</div>
						<div class="post-info">
						  <h4 class="font-weight-normal text-3 mb-0" style="line-height:22px">
						  <?=Html::a($recentBlogg->heading, ['/blog/view', 'slug' => $recentBlogg->slug], ['class' => 'text-dark'])?>
						  </h4>
						</div>
					  </article>
					</li>
				<?php } ?>
              </ul>
            </div>
            <div class="col-md-4">
              <div class="heading heading-border heading-middle-border">
				<h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Top Adventure Activities in India</strong></h3>
			  </div>
              <ul class="simple-post-list">
                <?php
				 $TagQuery = Tag::find()->where(['status' => 1])->orderBy('id')->limit(10)->all();    
				 foreach($TagQuery as $tagdisplay) {?>
                <li>
                  <article>
                    <div class="post-image">
                      <div class="img-thumbnail img-thumbnail-no-borders d-block">
					   <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/tag/small/'.$tagdisplay->image.'" alt="'.$tagdisplay->name.'" class="lazyload border-radius-0 popularimg" > ', ['/tag/view', 'slug' => $tagdisplay->slug])?>
                      </div>
                    </div>
                    <div class="post-info">
                      <h4 class="font-weight-normal text-3 mb-0" style="line-height:22px">
					  <?=Html::a($tagdisplay->name, ['/tag/view', 'slug' => $tagdisplay->slug], ['class' => 'text-dark'])?>
					  </h4>
                    </div>
                  </article>
                </li>
				<?php } ?>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>