<?php
use yii\helpers\Html;
use backend\models\Substory;
use backend\models\Story;

$StoryQueryy = Story::find()->where(['status' => 1])->orderBy(['id' => SORT_DESC])->one();
?>
<!doctype html>
<html>
  <head>
    <meta charset="utf-8">
    <title>Varanasi Tourist Places | Explore Our India</title>
    <link rel="canonical" href="https://www.exploreourindia.com/blog" 'main url'/>
    <meta name="viewport" content="width=device-width,minimum-scale=1,initial-scale=1">
    <meta name="description" content="Explore top tourist places in Varanasi – from Kashi Vishwanath Temple to Sarnath. A spiritual journey through India's oldest city.">
<meta property="og:image" content="https://www.exploreourindia.com<?php echo Yii::$app->urlManagerBackend->baseUrl.'/images/story/'.$StoryQueryy->image?>">
<meta property="twitter:image" content="https://www.exploreourindia.com<?php echo Yii::$app->urlManagerBackend->baseUrl.'/images/story/'.$StoryQueryy->image?>">
    <style amp-boilerplate>
      body {
        -webkit-animation: -amp-start 8s steps(1,end) 0s 1 normal both;
        -moz-animation: -amp-start 8s steps(1,end) 0s 1 normal both;
        -ms-animation: -amp-start 8s steps(1,end) 0s 1 normal both;
        animation: -amp-start 8s steps(1,end) 0s 1 normal both;
      }
      @-webkit-keyframes -amp-start {
        from {visibility:hidden}
        to {visibility:visible}
      }
      @-moz-keyframes -amp-start {
        from {visibility:hidden}
        to {visibility:visible}
      }
      @-ms-keyframes -amp-start {
        from {visibility:hidden}
        to {visibility:visible}
      }
      @keyframes -amp-start {
        from {visibility:hidden}
        to {visibility:visible}
      }
	   h1{
		  color:#fff;
		  text-shadow: 2px 2px 8px #000;}
		  
	  h2{
		  color:#fff;
		  text-shadow: 2px 2px 8px #000;}
	p{
		color:#FFF;
		text-shadow: 2px 2px 8px #000;
		margin-bottom:470px;}	  
	  
    </style>
    <noscript>
      <style amp-boilerplate>
        body {
          -webkit-animation:none;
          -moz-animation:none;
          -ms-animation:none;
          animation:none;
        }
      </style>
    </noscript>
    <script async src="https://cdn.ampproject.org/v0.js"></script>
    <script async custom-element="amp-story" src="https://cdn.ampproject.org/v0/amp-story-1.0.js"></script>
  </head>
  <body>
    <amp-story standalone
      title="Top Tourist Places in Varanasi"
      publisher="Explore Our India"
      publisher-logo-src="https://www.exploreourindia.com/favicon.ico"
      poster-portrait-src="https://your-image-url.com/cover.jpg">

      <?php 
foreach($storyQuery as $storydisplay) {
$storysubQuery = Substory::find()->where(['story_id' => $storydisplay->id, 'status' => 1])->orderBy(['id' => SORT_ASC])->all();
?>
      <amp-story-page id="cover">
        <amp-story-grid-layer template="fill">
          <amp-img src="<?php echo Yii::$app->urlManagerBackend->baseUrl.'/images/story/'.$storydisplay->image?>" width="720" height="1280" layout="responsive"></amp-img>
        </amp-story-grid-layer>
        <amp-story-grid-layer template="vertical">
          <h1><?=$storydisplay->heading?></h1>
          <?=$storydisplay->content?>
<?php if(count($storysubQuery) != '') {?>
          <?= Html::a('<button class="button" style="float:right">   <span>Explore Now</span>  </button>', ['/story/view', 'slug' => $storydisplay->slug], ['target' => '_blank']); ?>
<?php } ?>
        </amp-story-grid-layer>
      </amp-story-page>
<?php } ?>  

    </amp-story>
  </body>
</html>
<style>

.button {
  width: 150px;
  padding: 0;
  border: none;
  transform: rotate(5deg);
  transform-origin: center;
  font-family: "Gochi Hand", cursive;
  text-decoration: none;
  font-size: 15px;
  cursor: pointer;
  padding-bottom: 3px;
  border-radius: 5px;
  box-shadow: 0 2px 0 #494a4b;
  transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
  background-color: #ff0000;
}

.button span {
  background: #f1f5f8;
  display: block;
  padding: 0.5rem 1rem;
  border-radius: 5px;
  border: 2px solid #494a4b;
}

.button:active {
  transform: translateY(5px);
  padding-bottom: 0px;
  outline: 0;
}
</style>