<?php
use yii\helpers\Html;
?>
<!doctype html>
<html>
  <head>
    <meta charset="utf-8">
    <title><?=$storyQuery->meta_title?></title>
    <link rel="canonical" href="<?=$storyQuery->link?>" 'main url'/>
    <meta name="viewport" content="width=device-width,minimum-scale=1,initial-scale=1">
    <meta name="description" content="<?=$storyQuery->meta_description?>">
<meta property="og:image" content="https://www.exploreourindia.com<?php echo Yii::$app->urlManagerBackend->baseUrl.'/images/story/'.$storyQuery->image?>">
<meta property="twitter:image" content="https://www.exploreourindia.com<?php echo Yii::$app->urlManagerBackend->baseUrl.'/images/story/'.$storyQuery->image?>">
    <style amp-boilerplate>
      body {
        -webkit-animation: -amp-start 8s steps(1,end) 0s 1 normal both;
        -moz-animation: -amp-start 8s steps(1,end) 0s 1 normal both;
        -ms-animation: -amp-start 8s steps(1,end) 0s 1 normal both;
        animation: -amp-start 8s steps(1,end) 0s 1 normal both;
      }
      @-webkit-keyframes -amp-start {
        from {visibility:hidden}
        to {visibility:visible}
      }
      @-moz-keyframes -amp-start {
        from {visibility:hidden}
        to {visibility:visible}
      }
      @-ms-keyframes -amp-start {
        from {visibility:hidden}
        to {visibility:visible}
      }
      @keyframes -amp-start {
        from {visibility:hidden}
        to {visibility:visible}
      }
	   h1{
		  color:#fff;
		  text-shadow: 2px 2px 8px #000;}
		  
	  h2{
		  color:#fff;
		  text-shadow: 2px 2px 8px #000;}
	p{
		color:#FFF;
		text-shadow: 2px 2px 8px #000;
		margin-bottom:400px;}	  
	  
    </style>
    <noscript>
      <style amp-boilerplate>
        body {
          -webkit-animation:none;
          -moz-animation:none;
          -ms-animation:none;
          animation:none;
        }
      </style>
    </noscript>
    <script async src="https://cdn.ampproject.org/v0.js"></script>
    <script async custom-element="amp-story" src="https://cdn.ampproject.org/v0/amp-story-1.0.js"></script>
  </head>
  <body>
    <amp-story standalone
      title="Top Tourist Places in Varanasi"
      publisher="Explore Our India"
      publisher-logo-src="https://www.exploreourindia.com/favicon.ico"
      poster-portrait-src="https://your-image-url.com/cover.jpg">
	<amp-story-page id="cover">
        <amp-story-grid-layer template="fill">
          <amp-img src="<?php echo Yii::$app->urlManagerBackend->baseUrl.'/images/story/'.$storyQuery->image?>" width="720" height="1280" layout="responsive"></amp-img>
        </amp-story-grid-layer>
        <amp-story-grid-layer template="vertical">
          <h1><?=$storyQuery->heading?></h1>
          <?=$storyQuery->content?>
          <a href="<?=$storyQuery->link?>" 'main url' target="_blank" rel="noopener"><button class="button" style="float:right">   <span><strong>Explore Now</strong></span>  </button></a>
        </amp-story-grid-layer>
      </amp-story-page>  
<?php foreach($storysubQuery as $storydisplay) {?>
      <amp-story-page id="cover">
        <amp-story-grid-layer template="fill">
          <amp-img src="<?php echo Yii::$app->urlManagerBackend->baseUrl.'/images/story/substory/'.$storydisplay->image?>" width="720" height="1280" layout="responsive"></amp-img>
        </amp-story-grid-layer>
        <amp-story-grid-layer template="vertical">
          <h1><?=$storydisplay->heading?></h1>
          <?=$storydisplay->content?>
          <a href="<?=$storydisplay->link?>" 'main url' target="_blank" rel="noopener"><button class="button" style="float:right">   <span><strong>Explore Now</strong></span>  </button></a>
        </amp-story-grid-layer>
      </amp-story-page>
<?php } ?>
    </amp-story>
  </body>
</html>
<style>

.button {
  width: 150px;
  padding: 0;
  border: none;
  transform: rotate(5deg);
  transform-origin: center;
  font-family: "Gochi Hand", cursive;
  text-decoration: none;
  font-size: 15px;
  cursor: pointer;
  padding-bottom: 3px;
  border-radius: 5px;
  box-shadow: 0 2px 0 #494a4b;
  transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
  background-color: #ff0000;
}

.button span {
  background: #f1f5f8;
  display: block;
  padding: 0.5rem 1rem;
  border-radius: 5px;
  border: 2px solid #494a4b;
}

.button:active {
  transform: translateY(5px);
  padding-bottom: 0px;
  outline: 0;
}


</style>