<?php

namespace dektrium\user\models;
use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use dektrium\user\models\UserLog;

/**
 * UserLogSearch represents the model behind the search form about `app\modules\yadmin\modules\user\models\UserLog`.
 */
class UserLogSearch extends UserLog {

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['id', 'user_id', 'logintime', 'lastactivetime'], 'integer'],
            [['session_id', 'ip'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = UserLog::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 50,
            ],
            'sort' => [
                'defaultOrder' => [
                    'id' => SORT_DESC,
                ]
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'logintime' => $this->logintime,
            'lastactivetime' => $this->lastactivetime,
        ]);

        $query->andFilterWhere(['like', 'session_id', $this->session_id])
                ->andFilterWhere(['like', 'ip', $this->ip]);

        return $dataProvider;
    }

}
